/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.ProcessorDiagnosticsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessorDiagnosticsEntity;

public class ProcessorDiagnosticsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern PROCESSOR_DIAGNOSTICS_URI_PATTERN = Pattern.compile("/nifi-api/processors/[a-f0-9\\-]{36}/diagnostics");
    private final ProcessorDiagnosticsEntityMerger diagnosticsEntityMerger;

    public ProcessorDiagnosticsEndpointMerger(long componentStatusSnapshotMillis) {
        this.diagnosticsEntityMerger = new ProcessorDiagnosticsEntityMerger(componentStatusSnapshotMillis);
    }

    @Override
    public boolean canHandle(URI uri, String method) {
        if (!"GET".equalsIgnoreCase(method)) {
            return false;
        }
        return PROCESSOR_DIAGNOSTICS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        ProcessorDiagnosticsEntity clientEntity = (ProcessorDiagnosticsEntity)clientResponse.getClientResponse().readEntity(ProcessorDiagnosticsEntity.class);
        HashMap<NodeIdentifier, ProcessorDiagnosticsEntity> entityMap = new HashMap<NodeIdentifier, ProcessorDiagnosticsEntity>();
        for (NodeResponse nodeResponse : successfulResponses) {
            ProcessorDiagnosticsEntity nodeResponseEntity = nodeResponse == clientResponse ? clientEntity : (ProcessorDiagnosticsEntity)nodeResponse.getClientResponse().readEntity(ProcessorDiagnosticsEntity.class);
            entityMap.put(nodeResponse.getNodeId(), nodeResponseEntity);
        }
        this.diagnosticsEntityMerger.merge(clientEntity, entityMap);
        return new NodeResponse(clientResponse, (Entity)clientEntity);
    }
}

