/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.LoginException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.dbcp.DBCPValidator;
import org.apache.nifi.dbcp.ValidationResources;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hadoop.KerberosProperties;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;

@RequiresInstanceClassLoading
@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store", "hadoop"})
@CapabilityDescription(value="Provides a Database Connection Pooling Service for Hadoop related JDBC services. This service requires that the Database Driver Location(s) contains some version of a hadoop-common JAR, or a shaded JAR that shades hadoop-common.")
@DynamicProperty(name="The name of a Hadoop configuration property.", value="The value of the given Hadoop configuration property.", description="These properties will be set on the Hadoop configuration after loading any provided configuration files.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
public class HadoopDBCPConnectionPool
extends AbstractControllerService
implements DBCPService {
    private static final String ALLOW_EXPLICIT_KEYTAB = "NIFI_ALLOW_EXPLICIT_KEYTAB";
    private static final String HADOOP_CONFIGURATION_CLASS = "org.apache.hadoop.conf.Configuration";
    private static final String HADOOP_UGI_CLASS = "org.apache.hadoop.security.UserGroupInformation";
    private static final String DEFAULT_MIN_IDLE = "0";
    private static final String DEFAULT_MAX_IDLE = "8";
    private static final String DEFAULT_MAX_CONN_LIFETIME = "-1";
    private static final String DEFAULT_EVICTION_RUN_PERIOD = String.valueOf(-1L);
    private static final String DEFAULT_MIN_EVICTABLE_IDLE_TIME = "30 mins";
    private static final String DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME = String.valueOf(-1L);
    public static final PropertyDescriptor DATABASE_URL = new PropertyDescriptor.Builder().name("Database Connection URL").description("A database connection URL used to connect to a database. May contain database system name, host, port, database name and some parameters. The exact syntax of a database connection URL is specified by your DBMS.").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_DRIVERNAME = new PropertyDescriptor.Builder().name("Database Driver Class Name").description("Database driver class name").defaultValue(null).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_DRIVER_LOCATION = new PropertyDescriptor.Builder().name("database-driver-locations").displayName("Database Driver Location(s)").description("Comma-separated list of files/folders and/or URLs containing the driver JAR and its dependencies (if any). For example '/var/tmp/phoenix-client.jar'. NOTE: It is required that the resources specified by this property provide the classes from hadoop-common, such as Configuration and UserGroupInformation.").defaultValue(null).required(true).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY, ResourceType.URL}).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamicallyModifiesClasspath(true).build();
    static final PropertyDescriptor HADOOP_CONFIGURATION_RESOURCES = new PropertyDescriptor.Builder().name("hadoop-config-resources").displayName("Hadoop Configuration Resources").description("A file, or comma separated list of files, which contain the Hadoop configuration (core-site.xml, etc.). Without this, Hadoop will search the classpath, or will revert to a default configuration. Note that to enable authentication with Kerberos, the appropriate properties must be set in the configuration files.").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamicallyModifiesClasspath(true).build();
    public static final PropertyDescriptor DB_USER = new PropertyDescriptor.Builder().name("Database User").description("The user for the database").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password for the database user").defaultValue(null).required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_WAIT_TIME = new PropertyDescriptor.Builder().name("Max Wait Time").description("The maximum amount of time that the pool will wait (when there are no available connections)  for a connection to be returned before failing, or -1 to wait indefinitely. ").defaultValue("500 millis").required(true).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(false).build();
    public static final PropertyDescriptor MAX_TOTAL_CONNECTIONS = new PropertyDescriptor.Builder().name("Max Total Connections").description("The maximum number of active connections that can be allocated from this pool at the same time,  or negative for no limit.").defaultValue("8").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(false).build();
    public static final PropertyDescriptor VALIDATION_QUERY = new PropertyDescriptor.Builder().name("Validation-query").displayName("Validation query").description("Validation query used to validate connections before returning them. When connection is invalid, it get's dropped and new valid connection will be returned. Note!! Using validation might have some performance penalty.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MIN_IDLE = new PropertyDescriptor.Builder().displayName("Minimum Idle Connections").name("dbcp-min-idle-conns").description("The minimum number of connections that can remain idle in the pool, without extra ones being created, or zero to create none.").defaultValue("0").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_IDLE = new PropertyDescriptor.Builder().displayName("Max Idle Connections").name("dbcp-max-idle-conns").description("The maximum number of connections that can remain idle in the pool, without extra ones being released, or negative for no limit.").defaultValue("8").required(false).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_CONN_LIFETIME = new PropertyDescriptor.Builder().displayName("Max Connection Lifetime").name("dbcp-max-conn-lifetime").description("The maximum lifetime in milliseconds of a connection. After this time is exceeded the connection will fail the next activation, passivation or validation test. A value of zero or less means the connection has an infinite lifetime.").defaultValue("-1").required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor EVICTION_RUN_PERIOD = new PropertyDescriptor.Builder().displayName("Time Between Eviction Runs").name("dbcp-time-between-eviction-runs").description("The number of milliseconds to sleep between runs of the idle connection evictor thread. When non-positive, no idle connection evictor thread will be run.").defaultValue(DEFAULT_EVICTION_RUN_PERIOD).required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MIN_EVICTABLE_IDLE_TIME = new PropertyDescriptor.Builder().displayName("Minimum Evictable Idle Time").name("dbcp-min-evictable-idle-time").description("The minimum amount of time a connection may sit idle in the pool before it is eligible for eviction.").defaultValue("30 mins").required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor SOFT_MIN_EVICTABLE_IDLE_TIME = new PropertyDescriptor.Builder().displayName("Soft Minimum Evictable Idle Time").name("dbcp-soft-min-evictable-idle-time").description("The minimum amount of time a connection may sit idle in the pool before it is eligible for eviction by the idle connection evictor, with the extra condition that at least a minimum number of idle connections remain in the pool. When the not-soft version of this option is set to a positive value, it is examined first by the idle connection evictor: when idle connections are visited by the evictor, idle time is first compared against it (without considering the number of idle connections in the pool) and then against this soft option, including the minimum idle connections constraint.").defaultValue(DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME).required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    private File kerberosConfigFile = null;
    private KerberosProperties kerberosProperties;
    private List<PropertyDescriptor> properties;
    private volatile BasicDataSource dataSource;
    private volatile UserGroupInformation ugi;
    private volatile KerberosUser kerberosUser;
    private volatile Boolean foundHadoopDependencies;
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference<Object>(null);

    protected void init(ControllerServiceInitializationContext context) {
        this.kerberosConfigFile = context.getKerberosConfigurationFile();
        this.kerberosProperties = this.getKerberosProperties(this.kerberosConfigFile);
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(DATABASE_URL);
        props.add(DB_DRIVERNAME);
        props.add(DB_DRIVER_LOCATION);
        props.add(HADOOP_CONFIGURATION_RESOURCES);
        props.add(KERBEROS_CREDENTIALS_SERVICE);
        props.add(this.kerberosProperties.getKerberosPrincipal());
        props.add(this.kerberosProperties.getKerberosKeytab());
        props.add(this.kerberosProperties.getKerberosPassword());
        props.add(DB_USER);
        props.add(DB_PASSWORD);
        props.add(MAX_WAIT_TIME);
        props.add(MAX_TOTAL_CONNECTIONS);
        props.add(VALIDATION_QUERY);
        props.add(MIN_IDLE);
        props.add(MAX_IDLE);
        props.add(MAX_CONN_LIFETIME);
        props.add(EVICTION_RUN_PERIOD);
        props.add(MIN_EVICTABLE_IDLE_TIME);
        props.add(SOFT_MIN_EVICTABLE_IDLE_TIME);
        this.properties = Collections.unmodifiableList(props);
    }

    protected KerberosProperties getKerberosProperties(File kerberosConfigFile) {
        return new KerberosProperties(kerberosConfigFile);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        String resolvedKeytab;
        String resolvedPrincipal;
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        if (this.foundHadoopDependencies == null) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                Class.forName(HADOOP_CONFIGURATION_CLASS, true, classLoader);
                Class.forName(HADOOP_UGI_CLASS, true, classLoader);
                this.foundHadoopDependencies = true;
            }
            catch (ClassNotFoundException cnf) {
                this.getLogger().debug(cnf.getMessage(), (Throwable)cnf);
                this.foundHadoopDependencies = false;
            }
        }
        if (!this.foundHadoopDependencies.booleanValue()) {
            problems.add(new ValidationResult.Builder().subject(DB_DRIVER_LOCATION.getDisplayName()).valid(false).explanation("required Hadoop classes were not found in any of the specified resources, please ensure that hadoop-common is available").build());
            return problems;
        }
        String explicitPrincipal = validationContext.getProperty(this.kerberosProperties.getKerberosPrincipal()).evaluateAttributeExpressions().getValue();
        String explicitKeytab = validationContext.getProperty(this.kerberosProperties.getKerberosKeytab()).evaluateAttributeExpressions().getValue();
        String explicitPassword = validationContext.getProperty(this.kerberosProperties.getKerberosPassword()).getValue();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)validationContext.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (credentialsService == null) {
            resolvedPrincipal = explicitPrincipal;
            resolvedKeytab = explicitKeytab;
        } else {
            resolvedPrincipal = credentialsService.getPrincipal();
            resolvedKeytab = credentialsService.getKeytab();
        }
        boolean confFileProvided = validationContext.getProperty(HADOOP_CONFIGURATION_RESOURCES).isSet();
        if (confFileProvided) {
            String configFiles = validationContext.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
            ValidationResources resources = this.validationResourceHolder.get();
            if (resources == null || !configFiles.equals(resources.getConfigResources())) {
                this.getLogger().debug("Reloading validation resources");
                resources = new ValidationResources(configFiles, this.getConfigurationFromFiles(configFiles));
                this.validationResourceHolder.set(resources);
            }
            Configuration hadoopConfig = resources.getConfiguration();
            problems.addAll(KerberosProperties.validatePrincipalWithKeytabOrPassword((String)((Object)((Object)this)).getClass().getSimpleName(), (Configuration)hadoopConfig, (String)resolvedPrincipal, (String)resolvedKeytab, (String)explicitPassword, (ComponentLog)this.getLogger()));
        }
        if (credentialsService != null && (explicitPrincipal != null || explicitKeytab != null || explicitPassword != null)) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("Cannot specify a Kerberos Credentials Service while also specifying a Kerberos Principal, Kerberos Keytab, or Kerberos Password").build());
        }
        if (!this.isAllowExplicitKeytab() && explicitKeytab != null) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("The 'NIFI_ALLOW_EXPLICIT_KEYTAB' system environment variable is configured to forbid explicitly configuring Kerberos Keytab in processors. The Kerberos Credentials Service should be used instead of setting the Kerberos Keytab or Kerberos Principal property.").build());
        }
        return problems;
    }

    protected Configuration getConfigurationFromFiles(String configFiles) {
        Configuration conf = new Configuration();
        if (StringUtils.isNotBlank((CharSequence)configFiles)) {
            for (String configFile : configFiles.split(",")) {
                conf.addResource(new Path(configFile.trim()));
            }
        }
        return conf;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws IOException {
        String configFiles = context.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
        Configuration hadoopConfig = this.getConfigurationFromFiles(configFiles);
        for (Map.Entry entry : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (!descriptor.isDynamic()) continue;
            hadoopConfig.set(descriptor.getName(), context.getProperty(descriptor).evaluateAttributeExpressions().getValue());
        }
        if (SecurityUtil.isSecurityEnabled((Configuration)hadoopConfig)) {
            String resolvedKeytab;
            String resolvedPrincipal;
            String explicitPrincipal = context.getProperty(this.kerberosProperties.getKerberosPrincipal()).evaluateAttributeExpressions().getValue();
            String explicitKeytab = context.getProperty(this.kerberosProperties.getKerberosKeytab()).evaluateAttributeExpressions().getValue();
            String explicitPassword = context.getProperty(this.kerberosProperties.getKerberosPassword()).getValue();
            KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
            if (credentialsService != null) {
                resolvedPrincipal = credentialsService.getPrincipal();
                resolvedKeytab = credentialsService.getKeytab();
            } else {
                resolvedPrincipal = explicitPrincipal;
                resolvedKeytab = explicitKeytab;
            }
            if (resolvedKeytab != null) {
                this.kerberosUser = new KerberosKeytabUser(resolvedPrincipal, resolvedKeytab);
                this.getLogger().info("Security Enabled, logging in as principal {} with keytab {}", new Object[]{resolvedPrincipal, resolvedKeytab});
            } else if (explicitPassword != null) {
                this.kerberosUser = new KerberosPasswordUser(resolvedPrincipal, explicitPassword);
                this.getLogger().info("Security Enabled, logging in as principal {} with password", new Object[]{resolvedPrincipal});
            } else {
                throw new IOException("Unable to authenticate with Kerberos, no keytab or password was provided");
            }
            this.ugi = SecurityUtil.getUgiForKerberosUser((Configuration)hadoopConfig, (KerberosUser)this.kerberosUser);
            this.getLogger().info("Successfully logged in as principal " + resolvedPrincipal);
        } else {
            this.getLogger().info("Simple Authentication");
        }
        String dbUrl = context.getProperty(DATABASE_URL).evaluateAttributeExpressions().getValue();
        String driverName = context.getProperty(DB_DRIVERNAME).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DB_USER).evaluateAttributeExpressions().getValue();
        String passw = context.getProperty(DB_PASSWORD).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        Long maxWaitMillis = this.extractMillisWithInfinite(context.getProperty(MAX_WAIT_TIME).evaluateAttributeExpressions());
        Integer minIdle = context.getProperty(MIN_IDLE).evaluateAttributeExpressions().asInteger();
        Integer maxIdle = context.getProperty(MAX_IDLE).evaluateAttributeExpressions().asInteger();
        Long maxConnLifetimeMillis = this.extractMillisWithInfinite(context.getProperty(MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        Long timeBetweenEvictionRunsMillis = this.extractMillisWithInfinite(context.getProperty(EVICTION_RUN_PERIOD).evaluateAttributeExpressions());
        Long minEvictableIdleTimeMillis = this.extractMillisWithInfinite(context.getProperty(MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        Long softMinEvictableIdleTimeMillis = this.extractMillisWithInfinite(context.getProperty(SOFT_MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName(driverName);
        this.dataSource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.dataSource.setUrl(dbUrl);
        this.dataSource.setUsername(user);
        this.dataSource.setPassword(passw);
        this.dataSource.setMaxWaitMillis(maxWaitMillis.longValue());
        this.dataSource.setMaxTotal(maxTotal.intValue());
        this.dataSource.setMinIdle(minIdle.intValue());
        this.dataSource.setMaxIdle(maxIdle.intValue());
        this.dataSource.setMaxConnLifetimeMillis(maxConnLifetimeMillis.longValue());
        this.dataSource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue());
        this.dataSource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue());
        this.dataSource.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis.longValue());
        if (StringUtils.isEmpty((CharSequence)validationQuery)) {
            this.dataSource.setValidationQuery(validationQuery);
            this.dataSource.setTestOnBorrow(true);
        }
    }

    private Long extractMillisWithInfinite(PropertyValue prop) {
        return DEFAULT_MAX_CONN_LIFETIME.equals(prop.getValue()) ? -1L : prop.asTimePeriod(TimeUnit.MILLISECONDS);
    }

    @OnDisabled
    public void shutdown() throws SQLException, LoginException {
        try {
            if (this.kerberosUser != null) {
                this.kerberosUser.logout();
            }
        }
        finally {
            this.validationResourceHolder.set(null);
            this.foundHadoopDependencies = null;
            this.kerberosUser = null;
            this.ugi = null;
            try {
                if (this.dataSource != null) {
                    this.dataSource.close();
                }
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    public Connection getConnection() throws ProcessException {
        try {
            if (this.ugi != null) {
                this.getLogger().trace("getting UGI instance");
                if (this.kerberosUser != null) {
                    this.getLogger().debug("kerberosUser is " + this.kerberosUser);
                    try {
                        this.getLogger().debug("checking TGT on kerberosUser " + this.kerberosUser);
                        this.kerberosUser.checkTGTAndRelogin();
                    }
                    catch (LoginException e) {
                        throw new ProcessException("Unable to relogin with kerberos credentials for " + this.kerberosUser.getPrincipal(), (Throwable)e);
                    }
                } else {
                    this.getLogger().debug("kerberosUser was null, will not refresh TGT with KerberosUser");
                    this.ugi.checkTGTAndReloginFromKeytab();
                }
                try {
                    return (Connection)this.ugi.doAs(() -> this.dataSource.getConnection());
                }
                catch (UndeclaredThrowableException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof SQLException) {
                        throw (SQLException)cause;
                    }
                    throw e;
                }
            }
            this.getLogger().info("Simple Authentication");
            return this.dataSource.getConnection();
        }
        catch (IOException | InterruptedException | SQLException e) {
            this.getLogger().error("Error getting Connection: " + e.getMessage(), (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
    }

    public String toString() {
        return "HadoopDBCPConnectionPool[id=" + this.getIdentifier() + "]";
    }

    boolean isAllowExplicitKeytab() {
        return Boolean.parseBoolean(System.getenv(ALLOW_EXPLICIT_KEYTAB));
    }

    BasicDataSource getDataSource() {
        return this.dataSource;
    }
}

