/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.ProcessException;

abstract class AbstractKafkaProcessor<T extends Closeable>
extends AbstractSessionFactoryProcessor {
    private volatile boolean acceptTask = true;
    private final AtomicInteger taskCounter = new AtomicInteger();
    volatile T kafkaResource;

    AbstractKafkaProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        if (this.acceptTask) {
            this.taskCounter.incrementAndGet();
            ProcessSession session = sessionFactory.createSession();
            try {
                AbstractKafkaProcessor abstractKafkaProcessor = this;
                synchronized (abstractKafkaProcessor) {
                    if (this.kafkaResource == null) {
                        this.kafkaResource = this.buildKafkaResource(context, session);
                    }
                }
                boolean processed = this.rendezvousWithKafka(context, session);
                session.commit();
                if (processed) {
                    this.postCommit(context);
                }
                context.yield();
            }
            catch (Throwable e) {
                this.acceptTask = false;
                session.rollback(true);
                this.getLogger().error("{} failed to process due to {}; rolling back session", new Object[]{this, e});
            }
            finally {
                AbstractKafkaProcessor processed = this;
                synchronized (processed) {
                    if (this.taskCounter.decrementAndGet() == 0 && !this.acceptTask) {
                        this.close();
                        this.acceptTask = true;
                    }
                }
            }
        } else {
            context.yield();
        }
    }

    @OnStopped
    public void close() {
        if (this.taskCounter.get() == 0) {
            try {
                if (this.kafkaResource != null) {
                    try {
                        this.kafkaResource.close();
                    }
                    catch (Exception e) {
                        this.getLogger().warn("Failed while closing " + this.kafkaResource, (Throwable)e);
                    }
                }
            }
            finally {
                this.kafkaResource = null;
            }
        }
    }

    protected void postCommit(ProcessContext context) {
    }

    protected abstract boolean rendezvousWithKafka(ProcessContext var1, ProcessSession var2);

    protected abstract T buildKafkaResource(ProcessContext var1, ProcessSession var2) throws ProcessException;
}

