/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka;

import java.util.Collections;
import kafka.admin.AdminUtils;
import kafka.api.TopicMetadata;
import kafka.utils.ZKStringSerializer;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import scala.collection.JavaConversions;
import scala.collection.Set;

class KafkaUtils {
    KafkaUtils() {
    }

    static int retrievePartitionCountForTopic(String zookeeperConnectionString, String topicName) {
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(zookeeperConnectionString);
            zkClient.setZkSerializer(new ZkSerializer(){

                public byte[] serialize(Object o) throws ZkMarshallingError {
                    return ZKStringSerializer.serialize((Object)o);
                }

                public Object deserialize(byte[] bytes) throws ZkMarshallingError {
                    return ZKStringSerializer.deserialize((byte[])bytes);
                }
            });
            Set topicMetadatas = AdminUtils.fetchTopicMetadataFromZk((Set)JavaConversions.asScalaSet(Collections.singleton(topicName)), (ZkClient)zkClient);
            if (topicMetadatas != null && topicMetadatas.size() > 0) {
                int n = ((TopicMetadata)JavaConversions.asJavaSet((Set)topicMetadatas).iterator().next()).partitionsMetadata().size();
                return n;
            }
            try {
                throw new IllegalStateException("Failed to get metadata for topic " + topicName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to retrieve partitions for topic " + topicName, e);
            }
        }
        finally {
            try {
                zkClient.close();
            }
            catch (Exception exception) {}
        }
    }
}

