/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka;

import java.util.Random;
import kafka.producer.Partitioner;

public final class Partitioners {
    private Partitioners() {
    }

    public static class HashPartitioner
    implements Partitioner {
        public int partition(Object key, int numberOfPartitions) {
            if (key != null) {
                return (key.hashCode() & Integer.MAX_VALUE) % numberOfPartitions;
            }
            return 0;
        }
    }

    public static class RandomPartitioner
    implements Partitioner {
        private final Random random = new Random();

        public int partition(Object key, int numberOfPartitions) {
            return this.random.nextInt(numberOfPartitions);
        }
    }

    public static class RoundRobinPartitioner
    implements Partitioner {
        private volatile int index;

        public int partition(Object key, int numberOfPartitions) {
            int partitionIndex = this.next(numberOfPartitions);
            return partitionIndex;
        }

        private synchronized int next(int numberOfPartitions) {
            if (this.index >= numberOfPartitions) {
                this.index = 0;
            }
            return this.index++;
        }
    }
}

