/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.nifi.repository.schema.NamedValue;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;

public class SchemaRecordWriter {
    public void writeRecord(Record record, OutputStream out) throws IOException {
        out.write(1);
        this.writeRecordFields(record, out);
    }

    private void writeRecordFields(Record record, OutputStream out) throws IOException {
        DataOutputStream dos = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        for (RecordField field : record.getSchema().getFields()) {
            Object value = record.getFieldValue(field);
            try {
                this.writeFieldRepetitionAndValue(field, value, dos);
            }
            catch (Exception e) {
                throw new IOException("Failed to write field '" + field.getFieldName() + "'", e);
            }
        }
    }

    private void writeFieldRepetitionAndValue(RecordField field, Object value, DataOutputStream dos) throws IOException {
        switch (field.getRepetition()) {
            case EXACTLY_ONE: {
                if (value == null) {
                    throw new IllegalArgumentException("Record does not have a value for the '" + field.getFieldName() + "' but the field is required");
                }
                this.writeFieldValue(field, value, dos);
                break;
            }
            case ZERO_OR_MORE: {
                if (value == null) {
                    dos.writeInt(0);
                    break;
                }
                if (!(value instanceof Collection)) {
                    throw new IllegalArgumentException("Record contains a value of type '" + value.getClass() + "' for the '" + field.getFieldName() + "' but expected a Collection because the Repetition for the field is " + (Object)((Object)field.getRepetition()));
                }
                Collection collection = (Collection)value;
                dos.writeInt(collection.size());
                for (Object fieldValue : collection) {
                    this.writeFieldValue(field, fieldValue, dos);
                }
                break;
            }
            case ZERO_OR_ONE: {
                if (value == null) {
                    dos.write(0);
                    break;
                }
                dos.write(1);
                this.writeFieldValue(field, value, dos);
            }
        }
    }

    private void writeFieldValue(RecordField field, Object value, DataOutputStream out) throws IOException {
        switch (field.getFieldType()) {
            case BOOLEAN: {
                out.writeBoolean((Boolean)value);
                break;
            }
            case BYTE_ARRAY: {
                byte[] array = (byte[])value;
                out.writeInt(array.length);
                out.write(array);
                break;
            }
            case INT: {
                out.writeInt((Integer)value);
                break;
            }
            case LONG: {
                out.writeLong((Long)value);
                break;
            }
            case STRING: {
                out.writeUTF((String)value);
                break;
            }
            case LONG_STRING: {
                byte[] charArray = ((String)value).getBytes(StandardCharsets.UTF_8);
                out.writeInt(charArray.length);
                out.write(charArray);
                break;
            }
            case MAP: {
                Map map = (Map)value;
                out.writeInt(map.size());
                List<RecordField> subFields = field.getSubFields();
                RecordField keyField = subFields.get(0);
                RecordField valueField = subFields.get(1);
                for (Map.Entry entry : map.entrySet()) {
                    this.writeFieldRepetitionAndValue(keyField, entry.getKey(), out);
                    this.writeFieldRepetitionAndValue(valueField, entry.getValue(), out);
                }
                break;
            }
            case UNION: {
                NamedValue namedValue = (NamedValue)value;
                out.writeUTF(namedValue.getName());
                Record childRecord = (Record)namedValue.getValue();
                this.writeRecordFields(childRecord, out);
                break;
            }
            case COMPLEX: {
                Record record = (Record)value;
                this.writeRecordFields(record, out);
            }
        }
    }
}

