/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.security.krb.AbstractKerberosUser;
import org.apache.nifi.security.krb.KeytabConfiguration;

public class KerberosKeytabUser
extends AbstractKerberosUser {
    private final String keytabFile;

    public KerberosKeytabUser(String principal, String keytabFile) {
        super(principal);
        this.keytabFile = keytabFile;
        Validate.notBlank((CharSequence)keytabFile);
    }

    @Override
    protected LoginContext createLoginContext(Subject subject) throws LoginException {
        KeytabConfiguration config = new KeytabConfiguration(this.principal, this.keytabFile);
        return new LoginContext("KeytabConf", subject, null, config);
    }

    public String getKeytabFile() {
        return this.keytabFile;
    }

    @Override
    Subject getSubject() {
        return this.subject;
    }
}

