/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.xml;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlUtils {
    private static final String DISALLOW_DOCTYPES = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String ALLOW_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String ALLOW_EXTERNAL_PARAM_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String ALLOW_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static XMLStreamReader createSafeReader(InputStream inputStream) throws XMLStreamException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The provided input stream cannot be null");
        }
        return XmlUtils.createSafeReader(new StreamSource(inputStream));
    }

    public static XMLStreamReader createSafeReader(StreamSource source) throws XMLStreamException {
        if (source == null) {
            throw new IllegalArgumentException("The provided source cannot be null");
        }
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        return xif.createXMLStreamReader(source);
    }

    public static XMLReader createSafeSaxReader(SAXParserFactory saxParserFactory, ContentHandler contentHandler) throws SAXException, ParserConfigurationException {
        if (saxParserFactory == null) {
            throw new IllegalArgumentException("The provided SAX parser factory cannot be null");
        }
        if (contentHandler == null) {
            throw new IllegalArgumentException("The provided SAX content handler cannot be null");
        }
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setFeature(DISALLOW_DOCTYPES, true);
        xmlReader.setFeature(ALLOW_EXTERNAL_GENERAL_ENTITIES, false);
        xmlReader.setFeature(ALLOW_EXTERNAL_PARAM_ENTITIES, false);
        xmlReader.setContentHandler(contentHandler);
        return xmlReader;
    }

    public static DocumentBuilder createSafeDocumentBuilder(Schema schema, boolean isNamespaceAware) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setSchema(schema);
        docFactory.setNamespaceAware(isNamespaceAware);
        docFactory.setAttribute(DISALLOW_DOCTYPES, true);
        docFactory.setAttribute(ALLOW_EXTERNAL_DTD, false);
        docFactory.setAttribute(ALLOW_EXTERNAL_GENERAL_ENTITIES, false);
        docFactory.setAttribute(ALLOW_EXTERNAL_PARAM_ENTITIES, false);
        docFactory.setXIncludeAware(false);
        docFactory.setExpandEntityReferences(false);
        return docFactory.newDocumentBuilder();
    }

    public static DocumentBuilder createSafeDocumentBuilder(Schema schema) throws ParserConfigurationException {
        return XmlUtils.createSafeDocumentBuilder(schema, true);
    }

    public static DocumentBuilder createSafeDocumentBuilder(boolean isNamespaceAware) throws ParserConfigurationException {
        return XmlUtils.createSafeDocumentBuilder(null, isNamespaceAware);
    }
}

