/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.security.PrivilegedAction;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.krb.KeytabUser;

public class KeytabAction {
    private final KeytabUser keytabUser;
    private final PrivilegedAction action;
    private final ProcessContext context;
    private final ComponentLog logger;

    public KeytabAction(KeytabUser keytabUser, PrivilegedAction action, ProcessContext context, ComponentLog logger) {
        this.keytabUser = keytabUser;
        this.action = action;
        this.context = context;
        this.logger = logger;
        Validate.notNull((Object)this.keytabUser);
        Validate.notNull((Object)this.action);
        Validate.notNull((Object)this.context);
        Validate.notNull((Object)this.logger);
    }

    public void execute() {
        if (!this.keytabUser.isLoggedIn()) {
            try {
                this.keytabUser.login();
                this.logger.info("Successful login for {}", new Object[]{this.keytabUser.getPrincipal()});
            }
            catch (LoginException e) {
                this.context.yield();
                throw new ProcessException("Login failed due to: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.keytabUser.checkTGTAndRelogin();
        }
        catch (LoginException e) {
            this.context.yield();
            throw new ProcessException("Relogin check failed due to: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.keytabUser.doAs(this.action);
        }
        catch (SecurityException se) {
            this.logger.info("Privileged action failed, attempting relogin and retrying...");
            this.logger.debug("", (Throwable)se);
            try {
                this.keytabUser.logout();
                this.keytabUser.login();
                this.keytabUser.doAs(this.action);
            }
            catch (Exception e) {
                this.context.yield();
                throw new ProcessException("Retrying privileged action failed due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

