/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.nifi.security.util.KeyStoreUtils;

public final class SslContextFactory {
    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, String keystoreType, String truststore, char[] truststorePasswd, String truststoreType, ClientAuth clientAuth, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return SslContextFactory.createSslContext(keystore, keystorePasswd, keystorePasswd, keystoreType, truststore, truststorePasswd, truststoreType, clientAuth, protocol);
    }

    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, char[] keyPasswd, String keystoreType, String truststore, char[] truststorePasswd, String truststoreType, ClientAuth clientAuth, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStoreUtils.getKeyStore(keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            keyStore.load(keyStoreStream, keystorePasswd);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (keyPasswd == null) {
            keyManagerFactory.init(keyStore, keystorePasswd);
        } else {
            keyManagerFactory.init(keyStore, keyPasswd);
        }
        KeyStore trustStore = KeyStoreUtils.getTrustStore(truststoreType);
        try (FileInputStream trustStoreStream = new FileInputStream(truststore);){
            trustStore.load(trustStoreStream, truststorePasswd);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        if (ClientAuth.REQUIRED == clientAuth) {
            sslContext.getDefaultSSLParameters().setNeedClientAuth(true);
        } else if (ClientAuth.WANT == clientAuth) {
            sslContext.getDefaultSSLParameters().setWantClientAuth(true);
        } else {
            sslContext.getDefaultSSLParameters().setWantClientAuth(false);
        }
        return sslContext;
    }

    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, String keystoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return SslContextFactory.createSslContext(keystore, keystorePasswd, keystorePasswd, keystoreType, protocol);
    }

    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, char[] keyPasswd, String keystoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStoreUtils.getKeyStore(keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            keyStore.load(keyStoreStream, keystorePasswd);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (keyPasswd == null) {
            keyManagerFactory.init(keyStore, keystorePasswd);
        } else {
            keyManagerFactory.init(keyStore, keyPasswd);
        }
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init(keyManagerFactory.getKeyManagers(), new TrustManager[0], new SecureRandom());
        return ctx;
    }

    public static SSLContext createTrustSslContext(String truststore, char[] truststorePasswd, String truststoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore trustStore = KeyStoreUtils.getTrustStore(truststoreType);
        try (FileInputStream trustStoreStream = new FileInputStream(truststore);){
            trustStore.load(trustStoreStream, truststorePasswd);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init(new KeyManager[0], trustManagerFactory.getTrustManagers(), new SecureRandom());
        return ctx;
    }

    public static enum ClientAuth {
        WANT,
        REQUIRED,
        NONE;

    }
}

