/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authentication.single.user.writer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.nifi.authentication.single.user.SingleUserCredentials;
import org.apache.nifi.authentication.single.user.writer.LoginCredentialsWriter;

public class StandardLoginCredentialsWriter
implements LoginCredentialsWriter {
    private static final String PROVIDERS_PREFIX = "login-identity-providers-";
    private static final String PROVIDERS_SUFFIX = ".xml";
    private static final String CLASS_TAG = "class";
    private static final String PROVIDER_TAG = "provider";
    private static final String PROPERTY_TAG = "property";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String USERNAME_PROPERTY = "Username";
    private static final String PASSWORD_PROPERTY = "Password";
    private final XMLEventFactory eventFactory = XMLEventFactory.newFactory();
    private final File providersFile;

    public StandardLoginCredentialsWriter(File providersFile) {
        this.providersFile = providersFile;
    }

    @Override
    public void writeLoginCredentials(SingleUserCredentials singleUserCredentials) {
        try {
            File updatedProvidersFile = File.createTempFile(PROVIDERS_PREFIX, PROVIDERS_SUFFIX);
            this.writeLoginCredentials(singleUserCredentials, updatedProvidersFile);
            Files.move(updatedProvidersFile.toPath(), this.providersFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Writing Login Identity Providers Failed", e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Processing Login Identity Providers Failed", e);
        }
    }

    private void writeLoginCredentials(SingleUserCredentials singleUserCredentials, File updatedProvidersFile) throws IOException, XMLStreamException {
        try (FileOutputStream outputStream = new FileOutputStream(updatedProvidersFile);){
            XMLEventWriter providersWriter = this.getProvidersWriter(outputStream);
            try (FileInputStream inputStream = new FileInputStream(this.providersFile);){
                XMLEventReader providersReader = this.getProvidersReader(inputStream);
                this.updateLoginIdentityProviders(singleUserCredentials, providersReader, providersWriter);
                providersReader.close();
            }
            providersWriter.close();
        }
    }

    private void updateLoginIdentityProviders(SingleUserCredentials singleUserCredentials, XMLEventReader providersReader, XMLEventWriter providersWriter) throws XMLStreamException {
        boolean processingSingleUserProvider = false;
        while (providersReader.hasNext()) {
            XMLEvent event = providersReader.nextEvent();
            providersWriter.add(event);
            if (this.isStartClass(event)) {
                XMLEvent nextEvent = providersReader.nextEvent();
                providersWriter.add(nextEvent);
                if (nextEvent.isCharacters()) {
                    String providerClass = nextEvent.asCharacters().getData();
                    if (singleUserCredentials.getProviderClass().equals(providerClass)) {
                        processingSingleUserProvider = true;
                    }
                }
            } else if (this.isEndProvider(event)) {
                processingSingleUserProvider = false;
            }
            if (!processingSingleUserProvider) continue;
            if (this.isStartProperty(event, USERNAME_PROPERTY)) {
                this.processProperty(providersReader, providersWriter, singleUserCredentials.getUsername());
                continue;
            }
            if (!this.isStartProperty(event, PASSWORD_PROPERTY)) continue;
            this.processProperty(providersReader, providersWriter, singleUserCredentials.getPassword());
        }
    }

    private void processProperty(XMLEventReader providersReader, XMLEventWriter providersWriter, String propertyValue) throws XMLStreamException {
        XMLEvent nextEvent = providersReader.nextEvent();
        Characters propertyCharacters = this.eventFactory.createCharacters(propertyValue);
        providersWriter.add(propertyCharacters);
        if (nextEvent.isEndElement()) {
            providersWriter.add(nextEvent);
        }
    }

    private boolean isStartClass(XMLEvent event) {
        boolean found = false;
        if (event.isStartElement()) {
            StartElement startElement = event.asStartElement();
            found = CLASS_TAG.equals(startElement.getName().getLocalPart());
        }
        return found;
    }

    private boolean isStartProperty(XMLEvent event, String propertyName) {
        boolean found = false;
        if (event.isStartElement()) {
            StartElement startElement = event.asStartElement();
            found = PROPERTY_TAG.equals(startElement.getName().getLocalPart()) && this.isProperty(startElement, propertyName);
        }
        return found;
    }

    private boolean isProperty(StartElement startElement, String propertyName) {
        boolean found = false;
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!NAME_ATTRIBUTE.equals(attribute.getName().getLocalPart()) || !propertyName.equals(attribute.getValue())) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean isEndProvider(XMLEvent event) {
        boolean found = false;
        if (event.isEndElement()) {
            EndElement endElement = event.asEndElement();
            found = PROVIDER_TAG.equals(endElement.getName().getLocalPart());
        }
        return found;
    }

    private XMLEventWriter getProvidersWriter(OutputStream outputStream) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        return outputFactory.createXMLEventWriter(outputStream);
    }

    private XMLEventReader getProvidersReader(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        return inputFactory.createXMLEventReader(inputStream);
    }
}

