/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.snmp.processors.SNMPUtils;
import org.apache.nifi.snmp.processors.SNMPWorker;
import org.snmp4j.AbstractTarget;
import org.snmp4j.CommunityTarget;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

abstract class AbstractSNMPProcessor<T extends SNMPWorker>
extends AbstractProcessor {
    public static final PropertyDescriptor HOST = new PropertyDescriptor.Builder().name("snmp-hostname").displayName("Host Name").description("Network address of SNMP Agent (e.g., localhost)").required(true).defaultValue("localhost").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("snmp-port").displayName("Port").description("Numeric value identifying Port of SNMP Agent (e.g., 161)").required(true).defaultValue("161").addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor SNMP_VERSION = new PropertyDescriptor.Builder().name("snmp-version").displayName("SNMP Version").description("SNMP Version to use").required(true).allowableValues(new String[]{"SNMPv1", "SNMPv2c", "SNMPv3"}).defaultValue("SNMPv1").build();
    public static final PropertyDescriptor SNMP_COMMUNITY = new PropertyDescriptor.Builder().name("snmp-community").displayName("SNMP Community (v1 & v2c)").description("SNMP Community to use (e.g., public)").required(false).defaultValue("public").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SNMP_SECURITY_LEVEL = new PropertyDescriptor.Builder().name("snmp-security-level").displayName("SNMP Security Level").description("SNMP Security Level to use").required(true).allowableValues(new String[]{"noAuthNoPriv", "authNoPriv", "authPriv"}).defaultValue("authPriv").build();
    public static final PropertyDescriptor SNMP_SECURITY_NAME = new PropertyDescriptor.Builder().name("snmp-security-name").displayName("SNMP Security name / user name").description("Security name used for SNMP exchanges").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SNMP_AUTH_PROTOCOL = new PropertyDescriptor.Builder().name("snmp-authentication-protocol").displayName("SNMP Authentication Protocol").description("SNMP Authentication Protocol to use").required(true).allowableValues(new String[]{"MD5", "SHA", ""}).defaultValue("").build();
    public static final PropertyDescriptor SNMP_AUTH_PASSWORD = new PropertyDescriptor.Builder().name("snmp-authentication-passphrase").displayName("SNMP Authentication pass phrase").description("Pass phrase used for SNMP authentication protocol").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor SNMP_PRIV_PROTOCOL = new PropertyDescriptor.Builder().name("snmp-private-protocol").displayName("SNMP Private Protocol").description("SNMP Private Protocol to use").required(true).allowableValues(new String[]{"DES", "3DES", "AES128", "AES192", "AES256", ""}).defaultValue("").build();
    public static final PropertyDescriptor SNMP_PRIV_PASSWORD = new PropertyDescriptor.Builder().name("snmp-private-protocol-passphrase").displayName("SNMP Private protocol pass phrase").description("Pass phrase used for SNMP private protocol").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor SNMP_RETRIES = new PropertyDescriptor.Builder().name("snmp-retries").displayName("Number of retries").description("Set the number of retries when requesting the SNMP Agent").required(true).defaultValue("0").addValidator(StandardValidators.INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor SNMP_TIMEOUT = new PropertyDescriptor.Builder().name("snmp-timeout").displayName("Timeout (ms)").description("Set the timeout (in milliseconds) when requesting the SNMP Agent").required(true).defaultValue("5000").addValidator(StandardValidators.INTEGER_VALIDATOR).build();
    static List<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
    protected volatile AbstractTarget snmpTarget;
    protected volatile TransportMapping transportMapping;
    protected volatile Snmp snmp;
    protected volatile T targetResource;

    AbstractSNMPProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        AbstractSNMPProcessor abstractSNMPProcessor = this;
        synchronized (abstractSNMPProcessor) {
            this.buildTargetResource(context);
        }
        this.onTriggerSnmp(context, session);
    }

    @OnStopped
    public void close() {
        try {
            if (this.targetResource != null) {
                ((SNMPWorker)this.targetResource).close();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failure while closing target resource " + this.targetResource, (Throwable)e);
        }
        this.targetResource = null;
        try {
            if (this.transportMapping != null) {
                this.transportMapping.close();
            }
        }
        catch (IOException e) {
            this.getLogger().warn("Failure while closing UDP transport mapping", (Throwable)e);
        }
        this.transportMapping = null;
        try {
            if (this.snmp != null) {
                this.snmp.close();
            }
        }
        catch (IOException e) {
            this.getLogger().warn("Failure while closing UDP transport mapping", (Throwable)e);
        }
        this.snmp = null;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean isVersion3 = "SNMPv3".equals(validationContext.getProperty(SNMP_VERSION).getValue());
        if (isVersion3) {
            boolean isSecurityNameSet = validationContext.getProperty(SNMP_SECURITY_NAME).isSet();
            if (!isSecurityNameSet) {
                problems.add(new ValidationResult.Builder().input("SNMP Security Name").valid(false).explanation("SNMP Security Name must be set with SNMPv3.").build());
            }
            boolean isAuthProtOK = !"".equals(validationContext.getProperty(SNMP_AUTH_PROTOCOL).getValue());
            boolean isAuthPwdSet = validationContext.getProperty(SNMP_AUTH_PASSWORD).isSet();
            boolean isPrivProtOK = !"".equals(validationContext.getProperty(SNMP_PRIV_PROTOCOL).getValue());
            boolean isPrivPwdSet = validationContext.getProperty(SNMP_PRIV_PASSWORD).isSet();
            switch (validationContext.getProperty(SNMP_SECURITY_LEVEL).getValue()) {
                case "authNoPriv": {
                    if (isAuthProtOK && isAuthPwdSet) break;
                    problems.add(new ValidationResult.Builder().input("SNMP Security Level").valid(false).explanation("Authentication protocol and password must be set when using authNoPriv security level.").build());
                    break;
                }
                case "authPriv": {
                    if (isAuthProtOK && isAuthPwdSet && isPrivProtOK && isPrivPwdSet) break;
                    problems.add(new ValidationResult.Builder().input("SNMP Security Level").valid(false).explanation("All protocols and passwords must be set when using authPriv security level.").build());
                    break;
                }
            }
        } else {
            boolean isCommunitySet = validationContext.getProperty(SNMP_COMMUNITY).isSet();
            if (!isCommunitySet) {
                problems.add(new ValidationResult.Builder().input("SNMP Community").valid(false).explanation("SNMP Community must be set with SNMPv1 and SNMPv2c.").build());
            }
        }
        return problems;
    }

    protected abstract void onTriggerSnmp(ProcessContext var1, ProcessSession var2) throws ProcessException;

    protected abstract T finishBuildingTargetResource(ProcessContext var1);

    private void buildTargetResource(ProcessContext context) {
        if (this.transportMapping == null || !this.transportMapping.isListening() || this.snmp == null) {
            try {
                this.transportMapping = new DefaultUdpTransportMapping();
                this.snmp = new Snmp(this.transportMapping);
                if ("SNMPv3".equals(context.getProperty(SNMP_VERSION).getValue())) {
                    USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
                    SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
                }
                this.transportMapping.listen();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initialize UDP transport mapping", e);
            }
        }
        if (this.snmpTarget == null) {
            this.snmpTarget = this.createSnmpTarget(context);
        }
        if (this.targetResource == null) {
            this.targetResource = this.finishBuildingTargetResource(context);
        }
    }

    private AbstractTarget createSnmpTarget(ProcessContext context) {
        CommunityTarget result = null;
        String snmpVersion = context.getProperty(SNMP_VERSION).getValue();
        int version = 0;
        switch (snmpVersion) {
            case "SNMPv2c": {
                version = 1;
                break;
            }
            case "SNMPv3": {
                version = 3;
                break;
            }
            default: {
                version = 0;
            }
        }
        if (version == 3) {
            String username = context.getProperty(SNMP_SECURITY_NAME).getValue();
            String authPassword = context.getProperty(SNMP_AUTH_PASSWORD).getValue();
            String privPassword = context.getProperty(SNMP_PRIV_PASSWORD).getValue();
            String authProtocol = context.getProperty(SNMP_AUTH_PROTOCOL).getValue();
            String privProtocol = context.getProperty(SNMP_PRIV_PROTOCOL).getValue();
            OctetString aPwd = authPassword != null ? new OctetString(authPassword) : null;
            OctetString pPwd = privPassword != null ? new OctetString(privPassword) : null;
            this.snmp.getUSM().addUser(new OctetString(username), new UsmUser(new OctetString(username), SNMPUtils.getAuth(authProtocol), aPwd, SNMPUtils.getPriv(privProtocol), pPwd));
            result = new UserTarget();
            ((UserTarget)result).setSecurityLevel(SNMPUtils.getSecLevel(context.getProperty(SNMP_SECURITY_LEVEL).getValue()));
            String securityName = context.getProperty(SNMP_SECURITY_NAME).getValue();
            if (securityName != null) {
                ((UserTarget)result).setSecurityName(new OctetString(securityName));
            }
        } else {
            result = new CommunityTarget();
            String community = context.getProperty(SNMP_COMMUNITY).getValue();
            if (community != null) {
                result.setCommunity(new OctetString(community));
            }
        }
        result.setVersion(version);
        result.setAddress((Address)new UdpAddress(context.getProperty(HOST).getValue() + "/" + context.getProperty(PORT).getValue()));
        result.setRetries(context.getProperty(SNMP_RETRIES).asInteger().intValue());
        result.setTimeout((long)context.getProperty(SNMP_TIMEOUT).asInteger().intValue());
        return result;
    }

    static {
        descriptors.add(HOST);
        descriptors.add(PORT);
        descriptors.add(SNMP_VERSION);
        descriptors.add(SNMP_COMMUNITY);
        descriptors.add(SNMP_SECURITY_LEVEL);
        descriptors.add(SNMP_SECURITY_NAME);
        descriptors.add(SNMP_AUTH_PROTOCOL);
        descriptors.add(SNMP_AUTH_PASSWORD);
        descriptors.add(SNMP_PRIV_PROTOCOL);
        descriptors.add(SNMP_PRIV_PASSWORD);
        descriptors.add(SNMP_RETRIES);
        descriptors.add(SNMP_TIMEOUT);
    }
}

