/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.io.IOException;
import java.util.List;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.snmp.processors.SNMPWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.AbstractTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

final class SNMPGetter
extends SNMPWorker {
    private static final Logger logger = LoggerFactory.getLogger(SNMPGetter.class);
    private final OID oid;

    SNMPGetter(Snmp snmp, AbstractTarget target, OID oid) {
        super(snmp, target);
        this.oid = oid;
        logger.info("Successfully initialized SNMP Getter");
    }

    public ResponseEvent get() {
        try {
            Object pdu = null;
            pdu = this.target.getVersion() == 3 ? new ScopedPDU() : new PDU();
            pdu.add(new VariableBinding(this.oid));
            pdu.setType(-96);
            return this.snmp.get((PDU)pdu, (Target)this.target);
        }
        catch (IOException e) {
            logger.error("Failed to get information from SNMP agent; " + this, (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
    }

    public List<TreeEvent> walk() {
        TreeUtils treeUtils = new TreeUtils((Session)this.snmp, (PDUFactory)new DefaultPDUFactory());
        List events = treeUtils.getSubtree((Target)this.target, this.oid);
        return events;
    }

    @Override
    public String toString() {
        return super.toString() + ", OID:" + this.oid.toString();
    }
}

