/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.socket;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;

public class SSLContextFactory {
    private final String keystore;
    private final char[] keystorePass;
    private final String keystoreType;
    private final String truststore;
    private final char[] truststorePass;
    private final String truststoreType;
    private final KeyManager[] keyManagers;
    private final TrustManager[] trustManagers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextFactory(NiFiProperties properties) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, UnrecoverableKeyException {
        this.keystore = properties.getProperty("nifi.security.keystore");
        this.keystorePass = SSLContextFactory.getPass(properties.getProperty("nifi.security.keystorePasswd"));
        this.keystoreType = properties.getProperty("nifi.security.keystoreType");
        this.truststore = properties.getProperty("nifi.security.truststore");
        this.truststorePass = SSLContextFactory.getPass(properties.getProperty("nifi.security.truststorePasswd"));
        this.truststoreType = properties.getProperty("nifi.security.truststoreType");
        KeyStore keyStore = KeyStoreUtils.getKeyStore((String)this.keystoreType);
        FileInputStream keyStoreStream = new FileInputStream(this.keystore);
        try {
            keyStore.load(keyStoreStream, this.keystorePass);
        }
        finally {
            FileUtils.closeQuietly((Closeable)keyStoreStream);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keystorePass);
        KeyStore trustStore = KeyStoreUtils.getTrustStore((String)this.truststoreType);
        FileInputStream trustStoreStream = new FileInputStream(this.truststore);
        try {
            trustStore.load(trustStoreStream, this.truststorePass);
        }
        finally {
            FileUtils.closeQuietly((Closeable)trustStoreStream);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        this.keyManagers = keyManagerFactory.getKeyManagers();
        this.trustManagers = trustManagerFactory.getTrustManagers();
    }

    private static char[] getPass(String password) {
        return password == null ? null : password.toCharArray();
    }

    public SSLContext createSslContext() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagers, this.trustManagers, new SecureRandom());
        sslContext.getDefaultSSLParameters().setNeedClientAuth(true);
        return sslContext;
    }
}

