/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.handler;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.util.listen.dispatcher.AsyncChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.Event;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.event.EventFactoryUtil;
import org.apache.nifi.processor.util.listen.event.EventQueue;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processor.util.listen.response.ChannelResponse;
import org.apache.nifi.processors.standard.relp.frame.RELPEncoder;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.response.RELPChannelResponse;
import org.apache.nifi.processors.standard.relp.response.RELPResponse;

public class RELPFrameHandler<E extends Event<SocketChannel>> {
    static final String CMD_OPEN = "open";
    static final String CMD_CLOSE = "close";
    private final Charset charset;
    private final EventFactory<E> eventFactory;
    private final EventQueue<E> events;
    private final SelectionKey key;
    private final AsyncChannelDispatcher dispatcher;
    private final ProcessorLog logger;
    private final RELPEncoder encoder;

    public RELPFrameHandler(SelectionKey selectionKey, Charset charset, EventFactory<E> eventFactory, BlockingQueue<E> events, AsyncChannelDispatcher dispatcher, ProcessorLog logger) {
        this.key = selectionKey;
        this.charset = charset;
        this.eventFactory = eventFactory;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.events = new EventQueue(events, logger);
        this.encoder = new RELPEncoder(charset);
    }

    public void handle(RELPFrame frame, ChannelResponder<SocketChannel> responder, String sender) throws IOException, InterruptedException {
        if (CMD_OPEN.equals(frame.getCommand())) {
            Map<String, String> offers = RELPResponse.parseOffers(frame.getData(), this.charset);
            RELPChannelResponse response = new RELPChannelResponse(this.encoder, RELPResponse.open(frame.getTxnr(), offers));
            responder.addResponse((ChannelResponse)response);
            responder.respond();
        } else if (CMD_CLOSE.equals(frame.getCommand())) {
            RELPChannelResponse response = new RELPChannelResponse(this.encoder, RELPResponse.ok(frame.getTxnr()));
            responder.addResponse((ChannelResponse)response);
            responder.respond();
            this.dispatcher.completeConnection(this.key);
        } else {
            Map metadata = EventFactoryUtil.createMapWithSender((String)sender.toString());
            metadata.put("relp.txnr", String.valueOf(frame.getTxnr()));
            metadata.put("relp.command", frame.getCommand());
            Event event = this.eventFactory.create(frame.getData(), metadata, responder);
            this.events.offer(event);
        }
    }
}

