/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.handler;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.util.listen.dispatcher.AsyncChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.Event;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.handler.socket.SSLSocketChannelHandler;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processor.util.listen.response.socket.SSLSocketChannelResponder;
import org.apache.nifi.processors.standard.relp.frame.RELPDecoder;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.frame.RELPFrameException;
import org.apache.nifi.processors.standard.relp.handler.RELPFrameHandler;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannel;

public class RELPSSLSocketChannelHandler<E extends Event<SocketChannel>>
extends SSLSocketChannelHandler<E> {
    private RELPDecoder decoder;
    private RELPFrameHandler<E> frameHandler;

    public RELPSSLSocketChannelHandler(SelectionKey key, AsyncChannelDispatcher dispatcher, Charset charset, EventFactory<E> eventFactory, BlockingQueue<E> events, ProcessorLog logger) {
        super(key, dispatcher, charset, eventFactory, events, logger);
        this.decoder = new RELPDecoder(charset);
        this.frameHandler = new RELPFrameHandler<E>(key, charset, eventFactory, events, dispatcher, logger);
    }

    protected void processBuffer(SSLSocketChannel sslSocketChannel, SocketChannel socketChannel, int bytesRead, byte[] buffer) throws InterruptedException, IOException {
        InetAddress sender = socketChannel.socket().getInetAddress();
        try {
            for (int i = 0; i < bytesRead; ++i) {
                byte currByte = buffer[i];
                if (!this.decoder.process(currByte)) continue;
                RELPFrame frame = this.decoder.getFrame();
                this.logger.debug("Received RELP frame with transaction {} and command {}", new Object[]{frame.getTxnr(), frame.getCommand()});
                SSLSocketChannelResponder responder = new SSLSocketChannelResponder(socketChannel, sslSocketChannel);
                this.frameHandler.handle(frame, (ChannelResponder<SocketChannel>)responder, sender.toString());
            }
            this.logger.debug("Done processing buffer");
        }
        catch (RELPFrameException rfe) {
            this.logger.error("Error reading RELP frames due to {}", new Object[]{rfe.getMessage()}, (Throwable)rfe);
            ((AsyncChannelDispatcher)this.dispatcher).completeConnection(this.key);
        }
    }
}

