/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.response;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;

public class RELPResponse {
    public static final int OK = 200;
    public static final int ERROR = 500;
    public static final String RSP_CMD = "rsp";
    private final long txnr;
    private final int code;
    private final String message;
    private final String data;

    public RELPResponse(long txnr, int code) {
        this(txnr, code, null, null);
    }

    public RELPResponse(long txnr, int code, String message, String data) {
        this.txnr = txnr;
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public RELPFrame toFrame(Charset charset) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.code);
        if (this.message != null && !this.message.isEmpty()) {
            builder.append(' ');
            builder.append(this.message);
        }
        if (this.data != null) {
            builder.append('\n');
            builder.append(this.data);
        }
        byte[] data = builder.toString().getBytes(charset);
        return new RELPFrame.Builder().txnr(this.txnr).command(RSP_CMD).dataLength(data.length).data(data).build();
    }

    public static RELPResponse open(long txnr, Map<String, String> offers) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : offers.entrySet()) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(entry.getKey());
            if (entry.getValue() != null) {
                sb.append('=');
                sb.append(entry.getValue());
            }
            ++i;
        }
        return new RELPResponse(txnr, 200, "OK", sb.toString());
    }

    public static RELPResponse ok(long txnr) {
        return new RELPResponse(txnr, 200, "OK", null);
    }

    public static RELPResponse error(long txnr) {
        return new RELPResponse(txnr, 500, "ERROR", null);
    }

    public static Map<String, String> parseOffers(byte[] data, Charset charset) {
        String[] splits;
        HashMap<String, String> offers = new HashMap<String, String>();
        if (data == null || data.length == 0) {
            return offers;
        }
        String dataStr = new String(data, charset);
        for (String split : splits = dataStr.split("[\n]")) {
            String[] fields = split.split("=", 2);
            if (fields.length > 1) {
                offers.put(fields[0], fields[1]);
                continue;
            }
            offers.put(fields[0], fields[0]);
        }
        return offers;
    }
}

