/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import javax.jms.Message;
import org.apache.nifi.flowfile.FlowFile;

public class JmsProcessingSummary {
    private int messagesReceived;
    private long bytesReceived;
    private Message lastMessageReceived;
    private int flowFilesCreated;
    private FlowFile lastFlowFile;

    public JmsProcessingSummary() {
        this.messagesReceived = 0;
        this.bytesReceived = 0L;
        this.lastMessageReceived = null;
        this.flowFilesCreated = 0;
        this.lastFlowFile = null;
    }

    public JmsProcessingSummary(long bytesReceived, Message lastMessageReceived, FlowFile lastFlowFile) {
        this.messagesReceived = 1;
        this.bytesReceived = bytesReceived;
        this.lastMessageReceived = lastMessageReceived;
        this.flowFilesCreated = 1;
        this.lastFlowFile = lastFlowFile;
    }

    public void add(JmsProcessingSummary jmsProcessingSummary) {
        this.messagesReceived += jmsProcessingSummary.messagesReceived;
        this.bytesReceived += jmsProcessingSummary.bytesReceived;
        this.lastMessageReceived = jmsProcessingSummary.lastMessageReceived;
        this.flowFilesCreated += jmsProcessingSummary.flowFilesCreated;
        this.lastFlowFile = jmsProcessingSummary.lastFlowFile;
    }

    public int getMessagesReceived() {
        return this.messagesReceived;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public Message getLastMessageReceived() {
        return this.lastMessageReceived;
    }

    public int getFlowFilesCreated() {
        return this.flowFilesCreated;
    }

    public FlowFile getLastFlowFile() {
        return this.lastFlowFile;
    }
}

