/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import com.burgstaller.okhttp.DispatchingAuthenticator;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public class MultiAuthenticator
extends DispatchingAuthenticator {
    private String proxyUsername;
    private String proxyPassword;

    public MultiAuthenticator(Map<String, Authenticator> registry) {
        super(registry);
    }

    public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
        String credential = Credentials.basic((String)this.proxyUsername, (String)this.proxyPassword);
        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public static final class Builder {
        Map<String, Authenticator> registry = new HashMap<String, Authenticator>();

        public Builder with(String scheme, Authenticator authenticator) {
            this.registry.put(scheme, authenticator);
            return this;
        }

        public MultiAuthenticator build() {
            return new MultiAuthenticator(this.registry);
        }
    }
}

