/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.relp.frame.RELPFrameException;

public class RELPFrame {
    public static final byte DELIMITER = 10;
    public static final byte SEPARATOR = 32;
    private final long txnr;
    private final int dataLength;
    private final String command;
    private final byte[] data;

    private RELPFrame(Builder builder) {
        this.txnr = builder.txnr;
        this.dataLength = builder.dataLength;
        this.command = builder.command;
        byte[] byArray = this.data = builder.data == null ? new byte[]{} : builder.data;
        if (this.txnr < 0L || this.dataLength < 0 || this.command == null || StringUtils.isBlank((CharSequence)this.command) || this.data == null || this.dataLength != this.data.length) {
            throw new RELPFrameException("Invalid Frame");
        }
    }

    public long getTxnr() {
        return this.txnr;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getCommand() {
        return this.command;
    }

    public byte[] getData() {
        return this.data;
    }

    public static class Builder {
        long txnr;
        int dataLength;
        String command;
        byte[] data;

        public Builder() {
            this.reset();
        }

        public void reset() {
            this.txnr = -1L;
            this.dataLength = -1;
            this.command = null;
            this.data = null;
        }

        public Builder txnr(long txnr) {
            this.txnr = txnr;
            return this;
        }

        public Builder dataLength(int dataLength) {
            this.dataLength = dataLength;
            return this;
        }

        public Builder command(String command) {
            this.command = command;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public RELPFrame build() {
            return new RELPFrame(this);
        }
    }
}

