/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processors.standard.ListenHTTP;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.stream.io.StreamThrottler;
import org.apache.nifi.util.FlowFileUnpackager;
import org.apache.nifi.util.FlowFileUnpackagerV1;
import org.apache.nifi.util.FlowFileUnpackagerV2;
import org.apache.nifi.util.FlowFileUnpackagerV3;

@Path(value="")
public class ListenHTTPServlet
extends HttpServlet {
    private static final long serialVersionUID = 5329940480987723163L;
    public static final String FLOWFILE_CONFIRMATION_HEADER = "x-prefer-acknowledge-uri";
    public static final String LOCATION_HEADER_NAME = "Location";
    public static final String DEFAULT_FOUND_SUBJECT = "none";
    public static final String APPLICATION_FLOW_FILE_V1 = "application/flowfile";
    public static final String APPLICATION_FLOW_FILE_V2 = "application/flowfile-v2";
    public static final String APPLICATION_FLOW_FILE_V3 = "application/flowfile-v3";
    public static final String LOCATION_URI_INTENT_NAME = "x-location-uri-intent";
    public static final String LOCATION_URI_INTENT_VALUE = "flowfile-hold";
    public static final int FILES_BEFORE_CHECKING_DESTINATION_SPACE = 5;
    public static final String ACCEPT_HEADER_NAME = "Accept";
    public static final String ACCEPT_HEADER_VALUE = "application/flowfile-v3,application/flowfile-v2,application/flowfile,*/*;q=0.8";
    public static final String ACCEPT_ENCODING_NAME = "Accept-Encoding";
    public static final String ACCEPT_ENCODING_VALUE = "gzip";
    public static final String GZIPPED_HEADER = "flowfile-gzipped";
    public static final String PROTOCOL_VERSION_HEADER = "x-nifi-transfer-protocol-version";
    public static final String PROTOCOL_VERSION = "3";
    private final AtomicLong filesReceived = new AtomicLong(0L);
    private final AtomicBoolean spaceAvailable = new AtomicBoolean(true);
    private ProcessorLog logger;
    private AtomicReference<ProcessSessionFactory> sessionFactoryHolder;
    private volatile ProcessContext processContext;
    private Pattern authorizedPattern;
    private Pattern headerPattern;
    private ConcurrentMap<String, ListenHTTP.FlowFileEntryTimeWrapper> flowFileMap;
    private StreamThrottler streamThrottler;
    private String basePath;

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        this.logger = (ProcessorLog)context.getAttribute("logger");
        this.sessionFactoryHolder = (AtomicReference)context.getAttribute("sessionFactoryHolder");
        this.processContext = (ProcessContext)context.getAttribute("processContextHolder");
        this.authorizedPattern = (Pattern)context.getAttribute("authorityPattern");
        this.headerPattern = (Pattern)context.getAttribute("headerPattern");
        this.flowFileMap = (ConcurrentMap)context.getAttribute("flowFileMap");
        this.streamThrottler = (StreamThrottler)context.getAttribute("streamThrottler");
        this.basePath = (String)context.getAttribute("basePath");
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addHeader(ACCEPT_ENCODING_NAME, ACCEPT_ENCODING_VALUE);
        response.addHeader(ACCEPT_HEADER_NAME, ACCEPT_HEADER_VALUE);
        response.addHeader(PROTOCOL_VERSION_HEADER, PROTOCOL_VERSION);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ProcessSessionFactory sessionFactory;
        ProcessContext context = this.processContext;
        do {
            if ((sessionFactory = this.sessionFactoryHolder.get()) != null) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (sessionFactory == null);
        ProcessSession session = sessionFactory.createSession();
        FlowFile flowFile = null;
        String holdUuid = null;
        String foundSubject = null;
        try {
            GZIPInputStream in;
            X509Certificate cert;
            X509Certificate[] x509CertificateArray;
            int n;
            int n2;
            long n3 = this.filesReceived.getAndIncrement() % 5L;
            if (n3 == 0L || !this.spaceAvailable.get()) {
                if (context.getAvailableRelationships().isEmpty()) {
                    this.spaceAvailable.set(false);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received request from " + request.getRemoteHost() + " but no space available; Indicating Service Unavailable");
                    }
                    response.sendError(503);
                    return;
                }
                this.spaceAvailable.set(true);
            }
            response.setHeader("Content-Type", "text/plain");
            boolean contentGzipped = Boolean.parseBoolean(request.getHeader(GZIPPED_HEADER));
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            foundSubject = DEFAULT_FOUND_SUBJECT;
            if (certs != null && certs.length > 0 && (n2 = 0) < (n = (x509CertificateArray = certs).length) && !this.authorizedPattern.matcher(foundSubject = (cert = x509CertificateArray[n2]).getSubjectDN().getName()).matches()) {
                this.logger.warn("Rejecting transfer attempt from " + foundSubject + " because the DN is not authorized, host=" + request.getRemoteHost());
                response.sendError(403, "not allowed based on dn");
                return;
            }
            String destinationVersion = request.getHeader(PROTOCOL_VERSION_HEADER);
            Integer protocolVersion = null;
            if (destinationVersion != null) {
                try {
                    protocolVersion = Integer.valueOf(destinationVersion);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean destinationIsLegacyNiFi = protocolVersion == null;
            boolean createHold = Boolean.parseBoolean(request.getHeader(FLOWFILE_CONFIRMATION_HEADER));
            String contentType = request.getContentType();
            GZIPInputStream unthrottled = contentGzipped ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
            InputStream inputStream = in = this.streamThrottler == null ? unthrottled : this.streamThrottler.newThrottledInputStream((InputStream)unthrottled);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received request from " + request.getRemoteHost() + ", createHold=" + createHold + ", content-type=" + contentType + ", gzip=" + contentGzipped);
            }
            AtomicBoolean hasMoreData = new AtomicBoolean(false);
            Object unpackager = APPLICATION_FLOW_FILE_V3.equals(contentType) ? new FlowFileUnpackagerV3() : (APPLICATION_FLOW_FILE_V2.equals(contentType) ? new FlowFileUnpackagerV2() : (APPLICATION_FLOW_FILE_V1.equals(contentType) ? new FlowFileUnpackagerV1() : null));
            HashSet<FlowFile> flowFileSet = new HashSet<FlowFile>();
            do {
                long startNanos = System.nanoTime();
                HashMap<String, String> attributes = new HashMap<String, String>();
                flowFile = session.create();
                flowFile = session.write(flowFile, new OutputStreamCallback((FlowFileUnpackager)unpackager, in, hasMoreData, attributes, destinationIsLegacyNiFi){
                    final /* synthetic */ FlowFileUnpackager val$unpackager;
                    final /* synthetic */ InputStream val$in;
                    final /* synthetic */ AtomicBoolean val$hasMoreData;
                    final /* synthetic */ Map val$attributes;
                    final /* synthetic */ boolean val$destinationIsLegacyNiFi;
                    {
                        this.val$unpackager = flowFileUnpackager;
                        this.val$in = inputStream;
                        this.val$hasMoreData = atomicBoolean;
                        this.val$attributes = map;
                        this.val$destinationIsLegacyNiFi = bl;
                    }

                    public void process(OutputStream rawOut) throws IOException {
                        try (BufferedOutputStream bos = new BufferedOutputStream(rawOut, 65536);){
                            if (this.val$unpackager == null) {
                                IOUtils.copy((InputStream)this.val$in, (OutputStream)bos);
                                this.val$hasMoreData.set(false);
                            } else {
                                this.val$attributes.putAll(this.val$unpackager.unpackageFlowFile(this.val$in, (OutputStream)bos));
                                if (this.val$destinationIsLegacyNiFi) {
                                    if (this.val$attributes.containsKey("nf.file.name")) {
                                        this.val$attributes.put(CoreAttributes.FILENAME.key(), this.val$attributes.remove("nf.file.name"));
                                    }
                                    if (this.val$attributes.containsKey("nf.file.path")) {
                                        this.val$attributes.put(CoreAttributes.PATH.key(), this.val$attributes.remove("nf.file.path"));
                                    }
                                }
                                this.val$attributes.remove("parent.uuid");
                                this.val$hasMoreData.set(this.val$unpackager.hasMoreData());
                            }
                        }
                    }
                });
                long transferNanos = System.nanoTime() - startNanos;
                long transferMillis = TimeUnit.MILLISECONDS.convert(transferNanos, TimeUnit.NANOSECONDS);
                String nameVal = request.getHeader(CoreAttributes.FILENAME.key());
                if (StringUtils.isNotBlank((CharSequence)nameVal)) {
                    attributes.put(CoreAttributes.FILENAME.key(), nameVal);
                }
                Enumeration headerEnum = request.getHeaderNames();
                while (headerEnum.hasMoreElements()) {
                    String headerName = (String)headerEnum.nextElement();
                    if (this.headerPattern == null || !this.headerPattern.matcher(headerName).matches()) continue;
                    String headerValue = request.getHeader(headerName);
                    attributes.put(headerName, headerValue);
                }
                String sourceSystemFlowFileIdentifier = (String)attributes.get(CoreAttributes.UUID.key());
                if (sourceSystemFlowFileIdentifier != null) {
                    sourceSystemFlowFileIdentifier = "urn:nifi:" + sourceSystemFlowFileIdentifier;
                    attributes.put(CoreAttributes.UUID.key(), UUID.randomUUID().toString());
                }
                flowFile = session.putAllAttributes(flowFile, attributes);
                session.getProvenanceReporter().receive(flowFile, request.getRequestURL().toString(), sourceSystemFlowFileIdentifier, "Remote DN=" + foundSubject, transferMillis);
                flowFile = session.putAttribute(flowFile, "restlistener.remote.source.host", request.getRemoteHost());
                flowFile = session.putAttribute(flowFile, "restlistener.remote.user.dn", foundSubject);
                flowFileSet.add(flowFile);
                if (holdUuid != null) continue;
                holdUuid = flowFile.getAttribute(CoreAttributes.UUID.key());
            } while (hasMoreData.get());
            if (createHold) {
                ListenHTTP.FlowFileEntryTimeWrapper previousWrapper;
                String uuid;
                String string = uuid = holdUuid == null ? UUID.randomUUID().toString() : holdUuid;
                if (this.flowFileMap.containsKey(uuid)) {
                    uuid = UUID.randomUUID().toString();
                }
                ListenHTTP.FlowFileEntryTimeWrapper wrapper = new ListenHTTP.FlowFileEntryTimeWrapper(session, flowFileSet, System.currentTimeMillis());
                do {
                    if ((previousWrapper = this.flowFileMap.putIfAbsent(uuid, wrapper)) == null) continue;
                    uuid = UUID.randomUUID().toString();
                } while (previousWrapper != null);
                response.setStatus(303);
                String ackUri = "/" + this.basePath + "/holds/" + uuid;
                response.addHeader(LOCATION_HEADER_NAME, ackUri);
                response.addHeader(LOCATION_URI_INTENT_NAME, LOCATION_URI_INTENT_VALUE);
                response.getOutputStream().write(ackUri.getBytes("UTF-8"));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Ingested {} from Remote Host: [{}] Port [{}] SubjectDN [{}]; placed hold on these {} files with ID {}", new Object[]{flowFileSet, request.getRemoteHost(), request.getRemotePort(), foundSubject, flowFileSet.size(), uuid});
                }
            } else {
                response.setStatus(200);
                this.logger.info("Received from Remote Host: [{}] Port [{}] SubjectDN [{}]; transferring to 'success' {}", new Object[]{request.getRemoteHost(), request.getRemotePort(), foundSubject, flowFile});
                session.transfer(flowFileSet, ListenHTTP.RELATIONSHIP_SUCCESS);
                session.commit();
            }
        }
        catch (Throwable t) {
            session.rollback();
            if (flowFile == null) {
                this.logger.error("Unable to receive file from Remote Host: [{}] SubjectDN [{}] due to {}", new Object[]{request.getRemoteHost(), foundSubject, t});
            } else {
                this.logger.error("Unable to receive file {} from Remote Host: [{}] SubjectDN [{}] due to {}", new Object[]{flowFile, request.getRemoteHost(), foundSubject, t});
            }
            response.sendError(500, t.toString());
        }
    }
}

