/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.annotation.ThreadSafe;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;

@EventDriven
@Tags(value={"test", "debug", "processor", "utility", "flow", "FlowFile"})
@CapabilityDescription(value="The DebugFlow processor aids testing and debugging the FlowFile framework by allowing various responses to be explicitly triggered in response to the receipt of a FlowFile or a timer event without a FlowFile if using timer or cron based scheduling.  It can force responses needed to exercise or test various failure modes that can occur when a processor runs.")
@ThreadSafe
public class DebugFlow
extends AbstractProcessor {
    private final AtomicReference<Set<Relationship>> relationships = new AtomicReference();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles processed successfully.").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed to process.").build();
    private final AtomicReference<List<PropertyDescriptor>> propertyDescriptors = new AtomicReference();
    static final PropertyDescriptor FF_SUCCESS_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Success Iterations").description("Number of FlowFiles to forward to success relationship.").required(true).defaultValue("1").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_FAILURE_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Failure Iterations").description("Number of FlowFiles to forward to failure relationship.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_ROLLBACK_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Rollback Iterations").description("Number of FlowFiles to roll back (without penalty).").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_ROLLBACK_YIELD_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Rollback Yield Iterations").description("Number of FlowFiles to roll back and yield.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_ROLLBACK_PENALTY_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Rollback Penalty Iterations").description("Number of FlowFiles to roll back with penalty.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_EXCEPTION_ITERATIONS = new PropertyDescriptor.Builder().name("FlowFile Exception Iterations").description("Number of FlowFiles to throw exception.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor FF_EXCEPTION_CLASS = new PropertyDescriptor.Builder().name("FlowFile Exception Class").description("Exception class to be thrown (must extend java.lang.RuntimeException).").required(true).defaultValue("java.lang.RuntimeException").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            Class klass = DebugFlow.classNameToRuntimeExceptionClass(input);
            return new ValidationResult.Builder().subject(subject).input(input).valid(klass != null && RuntimeException.class.isAssignableFrom(klass)).explanation(subject + " class must exist and extend java.lang.RuntimeException").build();
        }
    }).build();
    static final PropertyDescriptor NO_FF_SKIP_ITERATIONS = new PropertyDescriptor.Builder().name("No FlowFile Skip Iterations").description("Number of times to skip onTrigger if no FlowFile.").required(true).defaultValue("1").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor NO_FF_EXCEPTION_ITERATIONS = new PropertyDescriptor.Builder().name("No FlowFile Exception Iterations").description("Number of times to throw NPE exception if no FlowFile.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor NO_FF_YIELD_ITERATIONS = new PropertyDescriptor.Builder().name("No FlowFile Yield Iterations").description("Number of times to yield if no FlowFile.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor NO_FF_EXCEPTION_CLASS = new PropertyDescriptor.Builder().name("No FlowFile Exception Class").description("Exception class to be thrown if no FlowFile (must extend java.lang.RuntimeException).").required(true).defaultValue("java.lang.RuntimeException").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            Class klass = DebugFlow.classNameToRuntimeExceptionClass(input);
            return new ValidationResult.Builder().subject(subject).input(input).valid(klass != null && RuntimeException.class.isAssignableFrom(klass)).explanation(subject + " class must exist and extend java.lang.RuntimeException").build();
        }
    }).build();
    static final PropertyDescriptor WRITE_ITERATIONS = new PropertyDescriptor.Builder().name("Write Iterations").description("Number of times to write to the FlowFile").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).required(true).defaultValue("0").build();
    static final PropertyDescriptor CONTENT_SIZE = new PropertyDescriptor.Builder().name("Content Size").description("The number of bytes to write each time that the FlowFile is written to").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).required(true).defaultValue("1 KB").build();
    private volatile Integer flowFileMaxSuccess = 0;
    private volatile Integer flowFileMaxFailure = 0;
    private volatile Integer flowFileMaxRollback = 0;
    private volatile Integer flowFileMaxYield = 0;
    private volatile Integer flowFileMaxPenalty = 0;
    private volatile Integer flowFileMaxException = 0;
    private volatile Integer noFlowFileMaxSkip = 0;
    private volatile Integer noFlowFileMaxException = 0;
    private volatile Integer noFlowFileMaxYield = 0;
    private volatile Integer flowFileCurrSuccess = 0;
    private volatile Integer flowFileCurrFailure = 0;
    private volatile Integer flowFileCurrRollback = 0;
    private volatile Integer flowFileCurrYield = 0;
    private volatile Integer flowFileCurrPenalty = 0;
    private volatile Integer flowFileCurrException = 0;
    private volatile Integer noFlowFileCurrSkip = 0;
    private volatile Integer noFlowFileCurrException = 0;
    private volatile Integer noFlowFileCurrYield = 0;
    private volatile Class<? extends RuntimeException> flowFileExceptionClass = null;
    private volatile Class<? extends RuntimeException> noFlowFileExceptionClass = null;
    private final FlowFileResponse curr_ff_resp = new FlowFileResponse();
    private final NoFlowFileResponse curr_noff_resp = new NoFlowFileResponse();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Relationship> getRelationships() {
        AtomicReference<Set<Relationship>> atomicReference = this.relationships;
        synchronized (atomicReference) {
            if (this.relationships.get() == null) {
                HashSet<Relationship> relSet = new HashSet<Relationship>();
                relSet.add(REL_SUCCESS);
                relSet.add(REL_FAILURE);
                this.relationships.compareAndSet(null, Collections.unmodifiableSet(relSet));
            }
            return this.relationships.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AtomicReference<List<PropertyDescriptor>> atomicReference = this.propertyDescriptors;
        synchronized (atomicReference) {
            if (this.propertyDescriptors.get() == null) {
                ArrayList<PropertyDescriptor> propList = new ArrayList<PropertyDescriptor>();
                propList.add(FF_SUCCESS_ITERATIONS);
                propList.add(FF_FAILURE_ITERATIONS);
                propList.add(FF_ROLLBACK_ITERATIONS);
                propList.add(FF_ROLLBACK_YIELD_ITERATIONS);
                propList.add(FF_ROLLBACK_PENALTY_ITERATIONS);
                propList.add(FF_EXCEPTION_ITERATIONS);
                propList.add(FF_EXCEPTION_CLASS);
                propList.add(NO_FF_SKIP_ITERATIONS);
                propList.add(NO_FF_EXCEPTION_ITERATIONS);
                propList.add(NO_FF_YIELD_ITERATIONS);
                propList.add(NO_FF_EXCEPTION_CLASS);
                propList.add(WRITE_ITERATIONS);
                propList.add(CONTENT_SIZE);
                this.propertyDescriptors.compareAndSet(null, Collections.unmodifiableList(propList));
            }
            return this.propertyDescriptors.get();
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.flowFileMaxSuccess = context.getProperty(FF_SUCCESS_ITERATIONS).asInteger();
        this.flowFileMaxFailure = context.getProperty(FF_FAILURE_ITERATIONS).asInteger();
        this.flowFileMaxYield = context.getProperty(FF_ROLLBACK_YIELD_ITERATIONS).asInteger();
        this.flowFileMaxRollback = context.getProperty(FF_ROLLBACK_ITERATIONS).asInteger();
        this.flowFileMaxPenalty = context.getProperty(FF_ROLLBACK_PENALTY_ITERATIONS).asInteger();
        this.flowFileMaxException = context.getProperty(FF_EXCEPTION_ITERATIONS).asInteger();
        this.noFlowFileMaxException = context.getProperty(NO_FF_EXCEPTION_ITERATIONS).asInteger();
        this.noFlowFileMaxYield = context.getProperty(NO_FF_YIELD_ITERATIONS).asInteger();
        this.noFlowFileMaxSkip = context.getProperty(NO_FF_SKIP_ITERATIONS).asInteger();
        this.curr_ff_resp.reset();
        this.curr_noff_resp.reset();
        this.flowFileExceptionClass = DebugFlow.classNameToRuntimeExceptionClass(context.getProperty(FF_EXCEPTION_CLASS).toString());
        this.noFlowFileExceptionClass = DebugFlow.classNameToRuntimeExceptionClass(context.getProperty(NO_FF_EXCEPTION_CLASS).toString());
    }

    /*
     * Unable to fully structure code
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        logger = this.getLogger();
        ff = session.get();
        pass = 2;
        while (pass > 0) {
            --pass;
            if (ff == null) {
                if (this.curr_noff_resp.state() == NoFlowFileResponseState.NO_FF_SKIP_RESPONSE) {
                    if (this.noFlowFileCurrSkip < this.noFlowFileMaxSkip) {
                        this.noFlowFileCurrSkip = this.noFlowFileCurrSkip + 1;
                        logger.info("DebugFlow skipping with no flow file");
                        return;
                    }
                    this.noFlowFileCurrSkip = 0;
                    this.curr_noff_resp.getNextCycle();
                }
                if (this.curr_noff_resp.state() == NoFlowFileResponseState.NO_FF_EXCEPTION_RESPONSE) {
                    if (this.noFlowFileCurrException < this.noFlowFileMaxException) {
                        this.noFlowFileCurrException = this.noFlowFileCurrException + 1;
                        logger.info("DebugFlow throwing NPE with no flow file");
                        message = "forced by " + this.getClass().getName();
                        try {
                            rte = this.noFlowFileExceptionClass.getConstructor(new Class[]{String.class}).newInstance(new Object[]{message});
                            throw rte;
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            if (!logger.isErrorEnabled()) ** GOTO lbl28
                            logger.error("{} unexpected exception throwing DebugFlow exception: {}", new Object[]{this, e});
                        }
                    } else {
                        this.noFlowFileCurrException = 0;
                        this.curr_noff_resp.getNextCycle();
                    }
                }
lbl28:
                // 5 sources

                if (this.curr_noff_resp.state() == NoFlowFileResponseState.NO_FF_YIELD_RESPONSE) {
                    if (this.noFlowFileCurrYield < this.noFlowFileMaxYield) {
                        this.noFlowFileCurrYield = this.noFlowFileCurrYield + 1;
                        logger.info("DebugFlow yielding with no flow file");
                        context.yield();
                        break;
                    }
                    this.noFlowFileCurrYield = 0;
                    this.curr_noff_resp.getNextCycle();
                }
                return;
            }
            writeIterations = context.getProperty(DebugFlow.WRITE_ITERATIONS).asInteger();
            if (writeIterations > 0 && pass == 1) {
                random = new Random();
                for (i = 0; i < writeIterations; ++i) {
                    data = new byte[context.getProperty(DebugFlow.CONTENT_SIZE).asDataSize(DataUnit.B).intValue()];
                    random.nextBytes(data);
                    ff = session.write(ff, new OutputStreamCallback(){

                        public void process(OutputStream out) throws IOException {
                            out.write(data);
                        }
                    });
                }
            }
            if (this.curr_ff_resp.state() == FlowFileResponseState.FF_SUCCESS_RESPONSE) {
                if (this.flowFileCurrSuccess < this.flowFileMaxSuccess) {
                    this.flowFileCurrSuccess = this.flowFileCurrSuccess + 1;
                    logger.info("DebugFlow transferring to success file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                    session.transfer(ff, DebugFlow.REL_SUCCESS);
                    session.commit();
                    break;
                }
                this.flowFileCurrSuccess = 0;
                this.curr_ff_resp.getNextCycle();
            }
            if (this.curr_ff_resp.state() == FlowFileResponseState.FF_FAILURE_RESPONSE) {
                if (this.flowFileCurrFailure < this.flowFileMaxFailure) {
                    this.flowFileCurrFailure = this.flowFileCurrFailure + 1;
                    logger.info("DebugFlow transferring to failure file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                    session.transfer(ff, DebugFlow.REL_FAILURE);
                    session.commit();
                    break;
                }
                this.flowFileCurrFailure = 0;
                this.curr_ff_resp.getNextCycle();
            }
            if (this.curr_ff_resp.state() == FlowFileResponseState.FF_ROLLBACK_RESPONSE) {
                if (this.flowFileCurrRollback < this.flowFileMaxRollback) {
                    this.flowFileCurrRollback = this.flowFileCurrRollback + 1;
                    logger.info("DebugFlow rolling back (no penalty) file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                    session.rollback();
                    session.commit();
                    break;
                }
                this.flowFileCurrRollback = 0;
                this.curr_ff_resp.getNextCycle();
            }
            if (this.curr_ff_resp.state() == FlowFileResponseState.FF_YIELD_RESPONSE) {
                if (this.flowFileCurrYield < this.flowFileMaxYield) {
                    this.flowFileCurrYield = this.flowFileCurrYield + 1;
                    logger.info("DebugFlow yielding file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                    session.rollback();
                    context.yield();
                    return;
                }
                this.flowFileCurrYield = 0;
                this.curr_ff_resp.getNextCycle();
            }
            if (this.curr_ff_resp.state() == FlowFileResponseState.FF_PENALTY_RESPONSE) {
                if (this.flowFileCurrPenalty < this.flowFileMaxPenalty) {
                    this.flowFileCurrPenalty = this.flowFileCurrPenalty + 1;
                    logger.info("DebugFlow rolling back (with penalty) file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                    session.rollback(true);
                    session.commit();
                    break;
                }
                this.flowFileCurrPenalty = 0;
                this.curr_ff_resp.getNextCycle();
            }
            if (this.curr_ff_resp.state() != FlowFileResponseState.FF_EXCEPTION_RESPONSE) continue;
            if (this.flowFileCurrException < this.flowFileMaxException) {
                this.flowFileCurrException = this.flowFileCurrException + 1;
                message = "forced by " + this.getClass().getName();
                logger.info("DebugFlow throwing NPE file={} UUID={}", new Object[]{ff.getAttribute(CoreAttributes.FILENAME.key()), ff.getAttribute(CoreAttributes.UUID.key())});
                try {
                    rte = this.flowFileExceptionClass.getConstructor(new Class[]{String.class}).newInstance(new Object[]{message});
                    throw rte;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("{} unexpected exception throwing DebugFlow exception: {}", new Object[]{this, e});
                    continue;
                }
            }
            this.flowFileCurrException = 0;
            this.curr_ff_resp.getNextCycle();
        }
    }

    private static Class<? extends RuntimeException> classNameToRuntimeExceptionClass(String name) {
        Class<?> klass = null;
        try {
            Class<?> klass2 = Class.forName(name);
            if (klass2 == RuntimeException.class || RuntimeException.class.isAssignableFrom(klass2)) {
                klass = klass2;
            }
        }
        catch (ClassNotFoundException e) {
            klass = null;
        }
        return klass;
    }

    private class NoFlowFileResponse {
        private final AtomicReference<NoFlowFileResponseState> current = new AtomicReference();

        NoFlowFileResponse() {
            this.current.set(NoFlowFileResponseState.NO_FF_SKIP_RESPONSE);
        }

        synchronized NoFlowFileResponseState state() {
            return this.current.get();
        }

        synchronized void getNextCycle() {
            this.current.set(this.current.get().next());
        }

        synchronized void reset() {
            this.current.set(NoFlowFileResponseState.NO_FF_SKIP_RESPONSE);
        }
    }

    private static enum NoFlowFileResponseState {
        NO_FF_SKIP_RESPONSE,
        NO_FF_EXCEPTION_RESPONSE,
        NO_FF_YIELD_RESPONSE;

        private NoFlowFileResponseState nextState;

        NoFlowFileResponseState next() {
            return this.nextState;
        }

        static {
            NoFlowFileResponseState.NO_FF_SKIP_RESPONSE.nextState = NO_FF_EXCEPTION_RESPONSE;
            NoFlowFileResponseState.NO_FF_EXCEPTION_RESPONSE.nextState = NO_FF_YIELD_RESPONSE;
            NoFlowFileResponseState.NO_FF_YIELD_RESPONSE.nextState = NO_FF_SKIP_RESPONSE;
        }
    }

    private class FlowFileResponse {
        private final AtomicReference<FlowFileResponseState> current = new AtomicReference();

        FlowFileResponse() {
            this.current.set(FlowFileResponseState.FF_SUCCESS_RESPONSE);
        }

        synchronized FlowFileResponseState state() {
            return this.current.get();
        }

        synchronized void getNextCycle() {
            this.current.set(this.current.get().next());
        }

        synchronized void reset() {
            this.current.set(FlowFileResponseState.FF_SUCCESS_RESPONSE);
        }
    }

    private static enum FlowFileResponseState {
        FF_SUCCESS_RESPONSE,
        FF_FAILURE_RESPONSE,
        FF_ROLLBACK_RESPONSE,
        FF_YIELD_RESPONSE,
        FF_PENALTY_RESPONSE,
        FF_EXCEPTION_RESPONSE;

        private FlowFileResponseState nextState;

        FlowFileResponseState next() {
            return this.nextState;
        }

        static {
            FlowFileResponseState.FF_SUCCESS_RESPONSE.nextState = FF_FAILURE_RESPONSE;
            FlowFileResponseState.FF_FAILURE_RESPONSE.nextState = FF_ROLLBACK_RESPONSE;
            FlowFileResponseState.FF_ROLLBACK_RESPONSE.nextState = FF_YIELD_RESPONSE;
            FlowFileResponseState.FF_YIELD_RESPONSE.nextState = FF_PENALTY_RESPONSE;
            FlowFileResponseState.FF_PENALTY_RESPONSE.nextState = FF_EXCEPTION_RESPONSE;
            FlowFileResponseState.FF_EXCEPTION_RESPONSE.nextState = FF_SUCCESS_RESPONSE;
        }
    }
}

