/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.bazaarvoice.jolt.JsonUtils;
import com.bazaarvoice.jolt.Transform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.TransformFactory;
import org.apache.nifi.stream.io.ByteArrayInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"json", "jolt", "transform", "shiftr", "chainr", "defaultr", "removr", "cardinality", "sort"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttribute(attribute="mime.type", description="Always set to application/json")
@CapabilityDescription(value="Applies a list of Jolt specifications to the flowfile JSON payload. A new FlowFile is created with transformed content and is routed to the 'success' relationship. If the JSON transform fails, the original FlowFile is routed to the 'failure' relationship.")
public class JoltTransformJSON
extends AbstractProcessor {
    public static final AllowableValue SHIFTR = new AllowableValue("jolt-transform-shift", "Shift", "Shift input JSON/data to create the output JSON.");
    public static final AllowableValue CHAINR = new AllowableValue("jolt-transform-chain", "Chain", "Execute list of Jolt transformations.");
    public static final AllowableValue DEFAULTR = new AllowableValue("jolt-transform-default", "Default", " Apply default values to the output JSON.");
    public static final AllowableValue REMOVR = new AllowableValue("jolt-transform-remove", "Remove", " Remove values from input data to create the output JSON.");
    public static final AllowableValue CARDINALITY = new AllowableValue("jolt-transform-card", "Cardinality", "Change the cardinality of input elements to create the output JSON.");
    public static final AllowableValue SORTR = new AllowableValue("jolt-transform-sort", "Sort", "Sort input json key values alphabetically. Any specification set is ignored.");
    public static final PropertyDescriptor JOLT_TRANSFORM = new PropertyDescriptor.Builder().name("jolt-transform").displayName("Jolt Transformation DSL").description("Specifies the Jolt Transformation that should be used with the provided specification.").required(true).allowableValues(new AllowableValue[]{CARDINALITY, CHAINR, DEFAULTR, REMOVR, SHIFTR, SORTR}).defaultValue(CHAINR.getValue()).build();
    public static final PropertyDescriptor JOLT_SPEC = new PropertyDescriptor.Builder().name("jolt-spec").displayName("Jolt Specification").description("Jolt Specification for transform of JSON data. This value is ignored if the Jolt Sort Transformation is selected.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile with transformed content will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid JSON), it will be routed to this relationship").build();
    private static final List<PropertyDescriptor> properties;
    private static final Set<Relationship> relationships;
    private volatile Transform transform;
    private static final String DEFAULT_CHARSET = "UTF-8";

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        String specValue;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String transform = validationContext.getProperty(JOLT_TRANSFORM).getValue();
        String string = specValue = validationContext.getProperty(JOLT_SPEC).isSet() ? validationContext.getProperty(JOLT_SPEC).getValue() : null;
        if (StringUtils.isEmpty((String)specValue)) {
            if (!SORTR.getValue().equals(transform)) {
                String message = "A specification is required for this transformation";
                results.add(new ValidationResult.Builder().valid(false).explanation(message).build());
            }
        } else {
            try {
                Object specJson = SORTR.getValue().equals(transform) ? null : JsonUtils.jsonToObject((String)specValue, (String)DEFAULT_CHARSET);
                TransformFactory.getTransform((String)transform, (Object)specJson);
            }
            catch (Exception e) {
                this.getLogger().info("Processor is not valid - " + e.toString());
                String message = "Specification not valid for the selected transformation.";
                results.add(new ValidationResult.Builder().valid(false).explanation(message).build());
            }
        }
        return results;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String jsonString;
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        StopWatch stopWatch = new StopWatch(true);
        final byte[] originalContent = new byte[(int)original.getSize()];
        session.read(original, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                StreamUtils.fillBuffer((InputStream)in, (byte[])originalContent, (boolean)true);
            }
        });
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(originalContent);
            Object inputJson = JsonUtils.jsonToObject((InputStream)bais);
            Object transformedJson = this.transform.transform(inputJson);
            jsonString = JsonUtils.toJsonString((Object)transformedJson);
        }
        catch (RuntimeException re) {
            logger.error("Unable to transform {} due to {}", new Object[]{original, re});
            session.transfer(original, REL_FAILURE);
            return;
        }
        FlowFile transformed = session.write(original, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                out.write(jsonString.getBytes(JoltTransformJSON.DEFAULT_CHARSET));
            }
        });
        String transformType = context.getProperty(JOLT_TRANSFORM).getValue();
        transformed = session.putAttribute(transformed, CoreAttributes.MIME_TYPE.key(), "application/json");
        session.transfer(transformed, REL_SUCCESS);
        session.getProvenanceReporter().modifyContent(transformed, "Modified With " + transformType, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
        logger.info("Transformed {}", new Object[]{original});
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        Object specJson = null;
        if (context.getProperty(JOLT_SPEC).isSet() && !SORTR.getValue().equals(context.getProperty(JOLT_TRANSFORM).getValue())) {
            specJson = JsonUtils.jsonToObject((String)context.getProperty(JOLT_SPEC).getValue(), (String)DEFAULT_CHARSET);
        }
        this.transform = TransformFactory.getTransform((String)context.getProperty(JOLT_TRANSFORM).getValue(), specJson);
    }

    static {
        ArrayList<PropertyDescriptor> _properties = new ArrayList<PropertyDescriptor>();
        _properties.add(JOLT_TRANSFORM);
        _properties.add(JOLT_SPEC);
        properties = Collections.unmodifiableList(_properties);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

