/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.standard.util.FlowFileSessionWrapper;

@Deprecated
public class Bin {
    private final long creationMomentEpochNs;
    private final long minimumSizeBytes;
    private final long maximumSizeBytes;
    private volatile int minimumEntries = 0;
    private volatile int maximumEntries = Integer.MAX_VALUE;
    private final String fileCountAttribute;
    final List<FlowFileSessionWrapper> binContents = new ArrayList<FlowFileSessionWrapper>();
    long size;
    int successiveFailedOfferings = 0;
    private static final Pattern intPattern = Pattern.compile("\\d+");

    public Bin(long minSizeBytes, long maxSizeBytes, int minEntries, int maxEntries, String fileCountAttribute) {
        this.minimumSizeBytes = minSizeBytes;
        this.maximumSizeBytes = maxSizeBytes;
        this.minimumEntries = minEntries;
        this.maximumEntries = maxEntries;
        this.fileCountAttribute = fileCountAttribute;
        this.creationMomentEpochNs = System.nanoTime();
        if (minSizeBytes > maxSizeBytes) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isFull() {
        return this.size >= this.minimumSizeBytes && this.binContents.size() >= this.minimumEntries && this.successiveFailedOfferings > 5 || this.size >= this.maximumSizeBytes || this.binContents.size() >= this.maximumEntries;
    }

    public boolean isFullEnough() {
        return this.isFull() || this.size >= this.minimumSizeBytes && this.binContents.size() >= this.minimumEntries;
    }

    public boolean isOlderThan(int duration, TimeUnit unit) {
        long ageInNanos = System.nanoTime() - this.creationMomentEpochNs;
        return ageInNanos > TimeUnit.NANOSECONDS.convert(duration, unit);
    }

    public boolean isOlderThan(Bin other) {
        return this.creationMomentEpochNs < other.creationMomentEpochNs;
    }

    public boolean offer(FlowFile flowFile, ProcessSession session) {
        String countValue;
        Integer count;
        if (this.size + flowFile.getSize() > this.maximumSizeBytes || this.binContents.size() >= this.maximumEntries) {
            ++this.successiveFailedOfferings;
            return false;
        }
        if (this.fileCountAttribute != null && (count = this.toInteger(countValue = flowFile.getAttribute(this.fileCountAttribute))) != null) {
            int currentMaximumEntries = this.maximumEntries;
            this.maximumEntries = Math.min(count, currentMaximumEntries);
            this.minimumEntries = currentMaximumEntries;
        }
        this.size += flowFile.getSize();
        this.binContents.add(new FlowFileSessionWrapper(flowFile, session));
        this.successiveFailedOfferings = 0;
        return true;
    }

    public Integer toInteger(String value) {
        if (value == null) {
            return null;
        }
        if (!intPattern.matcher(value).matches()) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<FlowFileSessionWrapper> getContents() {
        return this.binContents;
    }

    public long getBinAge() {
        long ageInNanos = System.nanoTime() - this.creationMomentEpochNs;
        return TimeUnit.MILLISECONDS.convert(ageInNanos, TimeUnit.NANOSECONDS);
    }
}

