/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.sql.PreparedStatement;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.nifi.queryrecord.FlowFileTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlJoinCalciteParameters
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SqlJoinCalciteParameters.class);
    private final String sql;
    private final CalciteConnection connection;
    private final PreparedStatement preparedStatement;
    private final FlowFileTable originalTable;
    private final FlowFileTable enrichmentTable;

    public SqlJoinCalciteParameters(String sql, CalciteConnection connection, PreparedStatement preparedStatement, FlowFileTable originalTable, FlowFileTable enrichmentTable) {
        this.sql = sql;
        this.connection = connection;
        this.preparedStatement = preparedStatement;
        this.originalTable = originalTable;
        this.enrichmentTable = enrichmentTable;
    }

    public String getSql() {
        return this.sql;
    }

    public CalciteConnection getConnection() {
        return this.connection;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public FlowFileTable getOriginalTable() {
        return this.originalTable;
    }

    public FlowFileTable getEnrichmentTable() {
        return this.enrichmentTable;
    }

    @Override
    public void close() {
        this.closeQuietly(this.preparedStatement, "Calcite Prepared Statement");
        this.closeQuietly((AutoCloseable)this.connection, "Calcite Connection");
        this.closeQuietly(this.originalTable, "Calcite 'Original' Table");
        this.closeQuietly(this.enrichmentTable, "Calcite 'Enrichment' Table");
    }

    private void closeQuietly(AutoCloseable closeable, String description) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close {}", (Object)description, (Object)e);
        }
    }
}

