/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.util.ProxiedEntitiesUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.VersionsClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.JerseyControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.JerseyFlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.JerseyProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.JerseyVersionsClient;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;

public class JerseyNiFiClient
implements NiFiClient {
    static final String NIFI_CONTEXT = "nifi-api";
    static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    static final int DEFAULT_READ_TIMEOUT = 10000;
    static final String AUTHORIZATION_HEADER = "Authorization";
    static final String BEARER = "Bearer";
    private final Client client;
    private final WebTarget baseTarget;

    private JerseyNiFiClient(Builder builder) {
        NiFiClientConfig clientConfig = builder.getConfig();
        if (clientConfig == null) {
            throw new IllegalArgumentException("NiFiClientConfig cannot be null");
        }
        String baseUrl = clientConfig.getBaseUrl();
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new IllegalArgumentException("Base URL cannot be blank");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (!baseUrl.endsWith(NIFI_CONTEXT)) {
            baseUrl = baseUrl + "/" + NIFI_CONTEXT;
        }
        try {
            new URI(baseUrl);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid base URL: " + e.getMessage(), e);
        }
        SSLContext sslContext = clientConfig.getSslContext();
        HostnameVerifier hostnameVerifier = clientConfig.getHostnameVerifier();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        if (hostnameVerifier != null) {
            clientBuilder.hostnameVerifier(hostnameVerifier);
        }
        int connectTimeout = clientConfig.getConnectTimeout() == null ? 10000 : clientConfig.getConnectTimeout();
        int readTimeout = clientConfig.getReadTimeout() == null ? 10000 : clientConfig.getReadTimeout();
        ClientConfig jerseyClientConfig = new ClientConfig();
        jerseyClientConfig.property("jersey.config.client.connectTimeout", (Object)connectTimeout);
        jerseyClientConfig.property("jersey.config.client.readTimeout", (Object)readTimeout);
        jerseyClientConfig.register((Object)JerseyNiFiClient.jacksonJaxbJsonProvider());
        clientBuilder.withConfig((Configuration)jerseyClientConfig);
        this.client = clientBuilder.build();
        this.baseTarget = this.client.target(baseUrl);
    }

    @Override
    public ControllerClient getControllerClient() {
        return new JerseyControllerClient(this.baseTarget);
    }

    @Override
    public ControllerClient getControllerClientForProxiedEntities(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyControllerClient(this.baseTarget, headers);
    }

    @Override
    public ControllerClient getControllerClientForToken(String base64token) {
        Map<String, String> headers = this.getHeadersWithToken(base64token);
        return new JerseyControllerClient(this.baseTarget, headers);
    }

    @Override
    public FlowClient getFlowClient() {
        return new JerseyFlowClient(this.baseTarget);
    }

    @Override
    public FlowClient getFlowClientForProxiedEntities(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyFlowClient(this.baseTarget, headers);
    }

    @Override
    public FlowClient getFlowClientForToken(String base64token) {
        Map<String, String> headers = this.getHeadersWithToken(base64token);
        return new JerseyFlowClient(this.baseTarget, headers);
    }

    @Override
    public ProcessGroupClient getProcessGroupClient() {
        return new JerseyProcessGroupClient(this.baseTarget);
    }

    @Override
    public ProcessGroupClient getProcessGroupClientForProxiedEntities(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyProcessGroupClient(this.baseTarget, headers);
    }

    @Override
    public ProcessGroupClient getProcessGroupClientForToken(String base64token) {
        Map<String, String> headers = this.getHeadersWithToken(base64token);
        return new JerseyProcessGroupClient(this.baseTarget, headers);
    }

    @Override
    public VersionsClient getVersionsClient() {
        return new JerseyVersionsClient(this.baseTarget);
    }

    @Override
    public VersionsClient getVersionsClientForProxiedEntities(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyVersionsClient(this.baseTarget, headers);
    }

    @Override
    public VersionsClient getVersionsClientForToken(String base64token) {
        Map<String, String> headers = this.getHeadersWithToken(base64token);
        return new JerseyVersionsClient(this.baseTarget, headers);
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Map<String, String> getHeadersWithToken(String base64token) {
        if (StringUtils.isBlank((CharSequence)base64token)) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(AUTHORIZATION_HEADER, "Bearer " + base64token);
        return headers;
    }

    private Map<String, String> getHeaders(String[] proxiedEntities) {
        String proxiedEntitiesValue = this.getProxiedEntitesValue(proxiedEntities);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (proxiedEntitiesValue != null) {
            headers.put("X-ProxiedEntitiesChain", proxiedEntitiesValue);
        }
        return headers;
    }

    private String getProxiedEntitesValue(String[] proxiedEntities) {
        if (proxiedEntities == null) {
            return null;
        }
        List proxiedEntityChain = Arrays.stream(proxiedEntities).map(ProxiedEntitiesUtils::formatProxyDn).collect(Collectors.toList());
        return StringUtils.join(proxiedEntityChain, (String)"");
    }

    private static JacksonJaxbJsonProvider jacksonJaxbJsonProvider() {
        JacksonJaxbJsonProvider jacksonJaxbJsonProvider = new JacksonJaxbJsonProvider();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(mapper.getTypeFactory()));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jacksonJaxbJsonProvider.setMapper(mapper);
        return jacksonJaxbJsonProvider;
    }

    public static class Builder
    implements NiFiClient.Builder {
        private NiFiClientConfig clientConfig;

        @Override
        public Builder config(NiFiClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @Override
        public NiFiClientConfig getConfig() {
            return this.clientConfig;
        }

        @Override
        public NiFiClient build() {
            return new JerseyNiFiClient(this);
        }
    }
}

