/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.composite;

import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.composite.AbstractCompositeCommand;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.PGImport;
import org.apache.nifi.toolkit.cli.impl.command.nifi.registry.CreateRegistryClient;
import org.apache.nifi.toolkit.cli.impl.command.nifi.registry.GetRegistryClientId;
import org.apache.nifi.toolkit.cli.impl.command.registry.bucket.CreateBucket;
import org.apache.nifi.toolkit.cli.impl.command.registry.bucket.ListBuckets;
import org.apache.nifi.toolkit.cli.impl.command.registry.flow.CreateFlow;
import org.apache.nifi.toolkit.cli.impl.command.registry.flow.ImportFlowVersion;
import org.apache.nifi.toolkit.cli.impl.result.BucketsResult;
import org.apache.nifi.toolkit.cli.impl.result.RegistryClientIDResult;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class QuickImport
extends AbstractCompositeCommand<StringResult> {
    public static final String BUCKET_NAME = "Quick Import";
    public static final String BUCKET_DESC = "Created to demonstrate quickly importing a flow with NiFi CLI.";
    public static final String FLOW_NAME = "Quick Import - ";
    public static final String FLOW_DESC = "Automatically imported on ";
    public static final String REG_CLIENT_NAME = "Quick Import";
    public static final String REG_CLIENT_DESC = "Automatically created on ";
    private final ListBuckets listBuckets = new ListBuckets();
    private final CreateBucket createBucket = new CreateBucket();
    private final CreateFlow createFlow = new CreateFlow();
    private final ImportFlowVersion importFlowVersion = new ImportFlowVersion();
    private final GetRegistryClientId getRegistryClientId = new GetRegistryClientId();
    private final CreateRegistryClient createRegistryClient = new CreateRegistryClient();
    private final PGImport pgImport = new PGImport();

    public QuickImport() {
        super("quick-import", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Imports a flow from a file or a public URL into a pre-defined bucket named 'Quick Import'. This command will create the bucket if it doesn't exist, and will create a new flow for each execution. The flow will then be imported to the given NiFi instance.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
        this.listBuckets.initialize(context);
        this.createBucket.initialize(context);
        this.createFlow.initialize(context);
        this.importFlowVersion.initialize(context);
        this.getRegistryClientId.initialize(context);
        this.createRegistryClient.initialize(context);
        this.pgImport.initialize(context);
    }

    @Override
    public StringResult doExecute(CommandLine cli, NiFiClient nifiClient, Properties nifiProps, NiFiRegistryClient registryClient, Properties registryProps) throws IOException, NiFiRegistryException, ParseException, NiFiClientException {
        boolean isInteractive = this.getContext().isInteractive();
        String registryClientBaseUrl = registryProps.getProperty(CommandOption.URL.getLongName());
        String registryClientId = this.getRegistryClientId(nifiClient, registryClientBaseUrl, isInteractive);
        String quickImportBucketId = this.getQuickImportBucketId(registryClient, isInteractive);
        String quickImportFlowId = this.createQuickImportFlow(registryClient, quickImportBucketId, isInteractive);
        String inputSource = cli.getOptionValue(CommandOption.INPUT_SOURCE.getLongName());
        if (StringUtils.isBlank((CharSequence)inputSource)) {
            throw new MissingOptionException("Missing required option --" + CommandOption.INPUT_SOURCE.getLongName());
        }
        String quickImportFlowVersion = this.importFlowVersion(registryClient, quickImportFlowId, isInteractive, inputSource);
        Properties pgImportProps = new Properties();
        pgImportProps.setProperty(CommandOption.REGISTRY_CLIENT_ID.getLongName(), registryClientId);
        pgImportProps.setProperty(CommandOption.BUCKET_ID.getLongName(), quickImportBucketId);
        pgImportProps.setProperty(CommandOption.FLOW_ID.getLongName(), quickImportFlowId);
        pgImportProps.setProperty(CommandOption.FLOW_VERSION.getLongName(), quickImportFlowVersion);
        StringResult createdPgResult = this.pgImport.doExecute(nifiClient, pgImportProps);
        if (isInteractive) {
            this.println();
            this.println("Imported process group to NiFi...");
            this.println();
        }
        return createdPgResult;
    }

    private String importFlowVersion(NiFiRegistryClient registryClient, String quickImportFlowId, boolean isInteractive, String inputSource) throws ParseException, IOException, NiFiRegistryException {
        Properties importVersionProps = new Properties();
        importVersionProps.setProperty(CommandOption.FLOW_ID.getLongName(), quickImportFlowId);
        importVersionProps.setProperty(CommandOption.INPUT_SOURCE.getLongName(), inputSource);
        StringResult createdVersion = this.importFlowVersion.doExecute(registryClient, importVersionProps);
        String quickImportFlowVersion = createdVersion.getResult();
        if (isInteractive) {
            this.println();
            this.println("Imported flow version...");
        }
        return quickImportFlowVersion;
    }

    private String createQuickImportFlow(NiFiRegistryClient registryClient, String quickImportBucketId, boolean isInteractive) throws ParseException, IOException, NiFiRegistryException {
        String flowName = FLOW_NAME + System.currentTimeMillis();
        String flowDescription = FLOW_DESC + new Date().toString();
        Properties createFlowProps = new Properties();
        createFlowProps.setProperty(CommandOption.FLOW_NAME.getLongName(), flowName);
        createFlowProps.setProperty(CommandOption.FLOW_DESC.getLongName(), flowDescription);
        createFlowProps.setProperty(CommandOption.BUCKET_ID.getLongName(), quickImportBucketId);
        StringResult createdFlow = this.createFlow.doExecute(registryClient, createFlowProps);
        String quickImportFlowId = createdFlow.getResult();
        if (isInteractive) {
            this.println();
            this.println("Created new flow '" + flowName + "'...");
        }
        return quickImportFlowId;
    }

    private String getQuickImportBucketId(NiFiRegistryClient registryClient, boolean isInteractive) throws IOException, NiFiRegistryException, MissingOptionException {
        BucketsResult bucketsResult = this.listBuckets.doExecute(registryClient, new Properties());
        Bucket quickImportBucket = bucketsResult.getResult().stream().filter(b -> "Quick Import".equals(b.getName())).findFirst().orElse(null);
        String quickImportBucketId = null;
        if (quickImportBucket != null) {
            quickImportBucketId = quickImportBucket.getIdentifier();
            if (isInteractive) {
                this.println();
                this.println("Found existing bucket 'Quick Import'...");
            }
        } else {
            Properties createBucketProps = new Properties();
            createBucketProps.setProperty(CommandOption.BUCKET_NAME.getLongName(), "Quick Import");
            createBucketProps.setProperty(CommandOption.BUCKET_DESC.getLongName(), BUCKET_DESC);
            StringResult createdBucketId = this.createBucket.doExecute(registryClient, createBucketProps);
            quickImportBucketId = createdBucketId.getResult();
            if (isInteractive) {
                this.println();
                this.println("Created new bucket 'Quick Import'...");
            }
        }
        return quickImportBucketId;
    }

    private String getRegistryClientId(NiFiClient nifiClient, String registryClientBaseUrl, boolean isInteractive) throws NiFiClientException, IOException, MissingOptionException {
        String registryClientId;
        Properties getRegClientProps = new Properties();
        getRegClientProps.setProperty(CommandOption.REGISTRY_CLIENT_URL.getLongName(), registryClientBaseUrl);
        try {
            RegistryClientIDResult registryClientResult = this.getRegistryClientId.doExecute(nifiClient, getRegClientProps);
            registryClientId = registryClientResult.getResult().getId();
            if (isInteractive) {
                this.println();
                this.println("Found existing registry client '" + registryClientResult.getResult().getName() + "'...");
            }
        }
        catch (Exception e) {
            registryClientId = null;
        }
        if (registryClientId == null) {
            Properties createRegClientProps = new Properties();
            createRegClientProps.setProperty(CommandOption.REGISTRY_CLIENT_NAME.getLongName(), "Quick Import");
            createRegClientProps.setProperty(CommandOption.REGISTRY_CLIENT_DESC.getLongName(), REG_CLIENT_DESC + new Date().toString());
            createRegClientProps.setProperty(CommandOption.REGISTRY_CLIENT_URL.getLongName(), registryClientBaseUrl);
            StringResult createdRegClient = this.createRegistryClient.doExecute(nifiClient, createRegClientProps);
            registryClientId = createdRegClient.getResult();
            if (isInteractive) {
                this.println();
                this.println("Created new registry client 'Quick Import'...");
            }
        }
        return registryClientId;
    }
}

