/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.nodes;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.NodeResult;
import org.apache.nifi.web.api.entity.NodeEntity;

public class GetNode
extends AbstractNiFiCommand<NodeResult> {
    public GetNode() {
        super("get-node", NodeResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves the status for a node in the NiFi cluster.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.NIFI_NODE_ID.createOption());
    }

    @Override
    public NodeResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String nodeId = this.getRequiredArg(properties, CommandOption.NIFI_NODE_ID);
        ControllerClient controllerClient = client.getControllerClient();
        NodeEntity nodeEntityResult = controllerClient.getNode(nodeId);
        return new NodeResult(this.getResultType(properties), nodeEntityResult);
    }
}

