/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VersionControlInfoResult;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;

public class PGGetVersion
extends AbstractNiFiCommand<VersionControlInfoResult> {
    public PGGetVersion() {
        super("pg-get-version", VersionControlInfoResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns the current version information for a version controlled process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VersionControlInfoResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        VersionControlInformationEntity entity = client.getVersionsClient().getVersionControlInfo(pgId);
        if (entity.getVersionControlInformation() == null) {
            throw new NiFiClientException("Process group is not under version control");
        }
        return new VersionControlInfoResult(this.getResultType(properties), entity);
    }
}

