/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;

public class ImportFlowVersion
extends AbstractNiFiRegistryCommand<StringResult> {
    public ImportFlowVersion() {
        super("import-flow-version", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Imports a version of a flow from a local file, or a public URL. The imported version automatically becomes the next version of the given flow.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.FLOW_ID.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws ParseException, IOException, NiFiRegistryException {
        Integer version;
        String contents;
        String flowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        String inputFile = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        try {
            URL url = new URL(inputFile);
            contents = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (MalformedURLException e) {
            URI uri = Paths.get(inputFile, new String[0]).toAbsolutePath().toUri();
            contents = IOUtils.toString((URI)uri, (Charset)StandardCharsets.UTF_8);
        }
        FlowClient flowClient = client.getFlowClient();
        FlowSnapshotClient snapshotClient = client.getFlowSnapshotClient();
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        VersionedFlowSnapshot deserializedSnapshot = (VersionedFlowSnapshot)objectMapper.readValue(contents, VersionedFlowSnapshot.class);
        if (deserializedSnapshot == null) {
            throw new IOException("Unable to deserialize flow version from " + inputFile);
        }
        VersionedFlow versionedFlow = flowClient.get(flowId);
        try {
            VersionedFlowSnapshotMetadata latestMetadata = snapshotClient.getLatestMetadata(flowId);
            version = latestMetadata.getVersion() + 1;
        }
        catch (NiFiRegistryException e) {
            version = 1;
        }
        VersionedFlowSnapshotMetadata metadata = new VersionedFlowSnapshotMetadata();
        metadata.setBucketIdentifier(versionedFlow.getBucketIdentifier());
        metadata.setFlowIdentifier(flowId);
        metadata.setVersion(version.intValue());
        metadata.setComments(deserializedSnapshot.getSnapshotMetadata().getComments());
        VersionedFlowSnapshot snapshot = new VersionedFlowSnapshot();
        snapshot.setSnapshotMetadata(metadata);
        snapshot.setFlowContents(deserializedSnapshot.getFlowContents());
        VersionedFlowSnapshot createdSnapshot = snapshotClient.create(snapshot);
        VersionedFlowSnapshotMetadata createdMetadata = createdSnapshot.getSnapshotMetadata();
        return new StringResult(String.valueOf(createdMetadata.getVersion()), this.getContext().isInteractive());
    }
}

