/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result;

import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;

public class VersionControlInfoResult
extends AbstractWritableResult<VersionControlInformationEntity> {
    private final VersionControlInformationEntity versionControlInformationEntity;

    public VersionControlInfoResult(ResultType resultType, VersionControlInformationEntity versionControlInformationEntity) {
        super(resultType);
        this.versionControlInformationEntity = versionControlInformationEntity;
        Validate.notNull((Object)this.versionControlInformationEntity);
    }

    @Override
    public VersionControlInformationEntity getResult() {
        return this.versionControlInformationEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        VersionControlInformationDTO dto = this.versionControlInformationEntity.getVersionControlInformation();
        if (dto == null) {
            return;
        }
        Table table = new Table.Builder().column("Registry", 20, 30, true).column("Bucket", 20, 30, true).column("Flow", 20, 30, true).column("Ver", 3, 3, false).build();
        table.addRow(dto.getRegistryName(), dto.getBucketName(), dto.getFlowName(), String.valueOf(dto.getVersion()));
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

