/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.VersionedFlowSnapshotMetadataResult;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;

public class VersionedFlowSnapshotMetadataSetResult
extends AbstractWritableResult<VersionedFlowSnapshotMetadataSetEntity> {
    private final VersionedFlowSnapshotMetadataSetEntity versionedFlowSnapshotMetadataSetEntity;

    public VersionedFlowSnapshotMetadataSetResult(ResultType resultType, VersionedFlowSnapshotMetadataSetEntity versionedFlowSnapshotMetadataSetEntity) {
        super(resultType);
        this.versionedFlowSnapshotMetadataSetEntity = versionedFlowSnapshotMetadataSetEntity;
        Validate.notNull((Object)this.versionedFlowSnapshotMetadataSetEntity);
    }

    @Override
    public VersionedFlowSnapshotMetadataSetEntity getResult() {
        return this.versionedFlowSnapshotMetadataSetEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Set entities = this.versionedFlowSnapshotMetadataSetEntity.getVersionedFlowSnapshotMetadataSet();
        if (entities == null || entities.isEmpty()) {
            return;
        }
        List<VersionedFlowSnapshotMetadata> snapshots = entities.stream().map(v -> v.getVersionedFlowSnapshotMetadata()).collect(Collectors.toList());
        VersionedFlowSnapshotMetadataResult result = new VersionedFlowSnapshotMetadataResult(this.resultType, snapshots);
        result.write(output);
    }
}

