/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.twitter;

import com.twitter.hbc.core.endpoint.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocationUtil {
    static final String LON = "[-+]?\\d{1,3}(?:[.]\\d+)?";
    static final String LAT = "[-+]?\\d{1,2}(?:[.]\\d+)?";
    static final String LON_LAT = "[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?";
    static final String LOCATION = "[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?,\\s*[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?";
    static final Pattern LOCATION_PATTERN = Pattern.compile("[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?,\\s*[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?");
    static final Pattern LOCATIONS_PATTERN = Pattern.compile("(?:[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?,\\s*[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?)(?:,\\s*[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?,\\s*[-+]?\\d{1,3}(?:[.]\\d+)?,\\s*[-+]?\\d{1,2}(?:[.]\\d+)?)*");

    public static List<Location> parseLocations(String input) {
        ArrayList<Location> locations = new ArrayList<Location>();
        Matcher locationsMatcher = LOCATIONS_PATTERN.matcher(input);
        if (locationsMatcher.matches()) {
            Matcher locationMatcher = LOCATION_PATTERN.matcher(input);
            while (locationMatcher.find()) {
                String location = locationMatcher.group();
                locations.add(LocationUtil.parseLocation(location));
            }
        } else {
            throw new IllegalStateException("The provided location string was invalid.");
        }
        return locations;
    }

    public static Location parseLocation(String location) {
        String[] corSplit = location.split(",");
        double swLon = Double.parseDouble(corSplit[0]);
        double swLat = Double.parseDouble(corSplit[1]);
        double neLon = Double.parseDouble(corSplit[2]);
        double neLat = Double.parseDouble(corSplit[3]);
        Location.Coordinate sw = new Location.Coordinate(swLon, swLat);
        Location.Coordinate ne = new Location.Coordinate(neLon, neLat);
        return new Location(sw, ne);
    }
}

