/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class CompressionOutputStream
extends OutputStream {
    public static final byte[] SYNC_BYTES = new byte[]{83, 89, 78, 67};
    public static final int DEFAULT_COMPRESSION_LEVEL = 1;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final int MIN_BUFFER_SIZE = 8192;
    private final OutputStream out;
    private final Deflater deflater;
    private final byte[] buffer;
    private final byte[] compressed;
    private int bufferIndex = 0;
    private boolean dataWritten = false;

    public CompressionOutputStream(OutputStream outStream) {
        this(outStream, 65536);
    }

    public CompressionOutputStream(OutputStream outStream, int bufferSize) {
        this(outStream, bufferSize, 1, 0);
    }

    public CompressionOutputStream(OutputStream outStream, int bufferSize, int level, int strategy) {
        if (bufferSize < 8192) {
            throw new IllegalArgumentException("Buffer size must be at least 8192");
        }
        this.out = outStream;
        this.deflater = new Deflater(level);
        this.deflater.setStrategy(strategy);
        this.buffer = new byte[bufferSize];
        this.compressed = new byte[bufferSize + 64];
    }

    protected void compressAndWrite() throws IOException {
        if (this.bufferIndex <= 0) {
            return;
        }
        this.deflater.setInput(this.buffer, 0, this.bufferIndex);
        this.deflater.finish();
        int compressedBytes = this.deflater.deflate(this.compressed);
        this.writeChunkHeader(compressedBytes);
        this.out.write(this.compressed, 0, compressedBytes);
        this.bufferIndex = 0;
        this.deflater.reset();
    }

    private void writeChunkHeader(int compressedBytes) throws IOException {
        if (this.dataWritten) {
            this.out.write(1);
        }
        this.out.write(SYNC_BYTES);
        this.dataWritten = true;
        this.writeInt(this.out, this.bufferIndex);
        this.writeInt(this.out, compressedBytes);
    }

    private void writeInt(OutputStream out, int val) throws IOException {
        out.write(val >>> 24);
        out.write(val >>> 16);
        out.write(val >>> 8);
        out.write(val);
    }

    protected boolean bufferFull() {
        return this.bufferIndex >= this.buffer.length;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.bufferIndex++] = (byte)(b & 0xFF);
        if (this.bufferFull()) {
            this.compressAndWrite();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int bytesThisIteration;
        for (int bytesLeft = len; bytesLeft > 0; bytesLeft -= bytesThisIteration) {
            int free = this.buffer.length - this.bufferIndex;
            bytesThisIteration = Math.min(bytesLeft, free);
            System.arraycopy(b, off + len - bytesLeft, this.buffer, this.bufferIndex, bytesThisIteration);
            this.bufferIndex += bytesThisIteration;
            if (!this.bufferFull()) continue;
            this.compressAndWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        this.compressAndWrite();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.compressAndWrite();
        this.out.write(0);
        this.out.flush();
    }
}

