/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteCountingOutputStream
extends OutputStream {
    private final OutputStream out;
    private long bytesWritten = 0L;

    public ByteCountingOutputStream(OutputStream out) {
        this.out = out;
    }

    public ByteCountingOutputStream(OutputStream out, long initialByteCount) {
        this.out = out;
        this.bytesWritten = initialByteCount;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.bytesWritten;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.bytesWritten += (long)len;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public OutputStream getWrappedStream() {
        return this.out;
    }
}

