/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.stream.io.exception.TokenTooLargeException;

public class StreamDemarcator
implements Closeable {
    private static final int INIT_BUFFER_SIZE = 8192;
    private final InputStream is;
    private final byte[] delimiterBytes;
    private final int maxDataSize;
    private final int initialBufferSize;
    private byte[] buffer;
    private int index;
    private int mark;
    private int readAheadLength;

    public StreamDemarcator(InputStream is, byte[] delimiterBytes, int maxDataSize) {
        this(is, delimiterBytes, maxDataSize, 8192);
    }

    public StreamDemarcator(InputStream is, byte[] delimiterBytes, int maxDataSize, int initialBufferSize) {
        this.validateInput(is, delimiterBytes, maxDataSize, initialBufferSize);
        this.is = is;
        this.delimiterBytes = delimiterBytes;
        this.initialBufferSize = initialBufferSize;
        this.buffer = new byte[initialBufferSize];
        this.maxDataSize = maxDataSize;
    }

    public byte[] nextToken() throws IOException {
        byte[] data = null;
        int j = 0;
        while (data == null && this.buffer != null) {
            if (this.index >= this.readAheadLength) {
                this.fill();
            }
            if (this.index >= this.readAheadLength) {
                data = this.extractDataToken(0);
                this.buffer = null;
                continue;
            }
            byte byteVal = this.buffer[this.index++];
            if (this.delimiterBytes != null && this.delimiterBytes[j] == byteVal) {
                if (++j != this.delimiterBytes.length) continue;
                data = this.extractDataToken(this.delimiterBytes.length);
                this.mark = this.index;
                j = 0;
                continue;
            }
            j = 0;
        }
        return data;
    }

    private void fill() throws IOException {
        int bytesRead;
        if (this.index >= this.buffer.length) {
            if (this.mark == 0) {
                byte[] newBuff = new byte[this.buffer.length + this.initialBufferSize];
                System.arraycopy(this.buffer, 0, newBuff, 0, this.buffer.length);
                this.buffer = newBuff;
            } else {
                int length = this.index - this.mark;
                System.arraycopy(this.buffer, this.mark, this.buffer, 0, length);
                this.index = length;
                this.mark = 0;
                this.readAheadLength = length;
            }
        }
        while ((bytesRead = this.is.read(this.buffer, this.index, this.buffer.length - this.index)) == 0) {
        }
        if (bytesRead != -1) {
            this.readAheadLength = this.index + bytesRead;
            if (this.readAheadLength > this.maxDataSize) {
                throw new TokenTooLargeException("A message in the stream exceeds the maximum allowed message size of " + this.maxDataSize + " bytes.");
            }
        }
    }

    private byte[] extractDataToken(int lengthSubtract) {
        byte[] data = null;
        int length = this.index - this.mark - lengthSubtract;
        if (length > 0) {
            data = new byte[length];
            System.arraycopy(this.buffer, this.mark, data, 0, data.length);
        }
        return data;
    }

    private void validateInput(InputStream is, byte[] delimiterBytes, int maxDataSize, int initialBufferSize) {
        if (is == null) {
            throw new IllegalArgumentException("'is' must not be null");
        }
        if (maxDataSize <= 0) {
            throw new IllegalArgumentException("'maxDataSize' must be > 0");
        }
        if (initialBufferSize <= 0) {
            throw new IllegalArgumentException("'initialBufferSize' must be > 0");
        }
        if (delimiterBytes != null && delimiterBytes.length == 0) {
            throw new IllegalArgumentException("'delimiterBytes' is an optional argument, but when provided its length must be > 0");
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

