/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io.util;

import java.io.IOException;
import java.io.InputStream;

public class TextLineDemarcator {
    private static final int INIT_BUFFER_SIZE = 8192;
    private final InputStream is;
    private final int initialBufferSize;
    private byte[] buffer;
    private int index;
    private int mark;
    private long offset;
    private int bufferLength;

    public TextLineDemarcator(InputStream is) {
        this(is, 8192);
    }

    public TextLineDemarcator(InputStream is, int initialBufferSize) {
        if (is == null) {
            throw new IllegalArgumentException("'is' must not be null.");
        }
        if (initialBufferSize < 1) {
            throw new IllegalArgumentException("'initialBufferSize' must be > 0.");
        }
        this.is = is;
        this.initialBufferSize = initialBufferSize;
        this.buffer = new byte[initialBufferSize];
    }

    public OffsetInfo nextOffsetInfo() {
        return this.nextOffsetInfo(null);
    }

    public OffsetInfo nextOffsetInfo(byte[] startsWith) {
        int i;
        OffsetInfo offsetInfo = null;
        int lineLength = 0;
        byte[] token = null;
        block0: while (this.bufferLength != -1) {
            if (this.index >= this.bufferLength) {
                this.fill();
            }
            if (this.bufferLength == -1) continue;
            for (i = this.index; i < this.bufferLength; ++i) {
                byte byteVal = this.buffer[i];
                ++lineLength;
                int crlfLength = this.isEol(byteVal, i);
                if (crlfLength <= 0) continue;
                i += crlfLength;
                if (crlfLength == 2) {
                    ++lineLength;
                }
                offsetInfo = new OffsetInfo(this.offset, lineLength, crlfLength);
                if (startsWith != null) {
                    token = this.extractDataToken(lineLength);
                }
                this.mark = this.index = i;
                break block0;
            }
            this.index = i;
        }
        if (lineLength > 0 && offsetInfo == null) {
            offsetInfo = new OffsetInfo(this.offset, lineLength, 0);
            if (startsWith != null) {
                token = this.extractDataToken(lineLength);
            }
        }
        this.offset += (long)lineLength;
        if (startsWith != null) {
            for (i = 0; i < startsWith.length; ++i) {
                byte sB = startsWith[i];
                if (token == null || sB == token[i]) continue;
                offsetInfo.setStartsWithMatch(0);
                break;
            }
        }
        return offsetInfo;
    }

    private int isEol(byte currentByte, int currentIndex) {
        int crlfLength = 0;
        if (currentByte == 10) {
            crlfLength = 1;
        } else if (currentByte == 13) {
            if (currentIndex + 1 >= this.bufferLength) {
                this.index = currentIndex + 1;
                this.fill();
            }
            crlfLength = (currentByte = this.buffer[currentIndex + 1]) == 10 ? 2 : 1;
        }
        return crlfLength;
    }

    private byte[] extractDataToken(int length) {
        byte[] data = null;
        if (length > 0) {
            data = new byte[length];
            System.arraycopy(this.buffer, this.mark, data, 0, data.length);
        }
        return data;
    }

    private void fill() {
        if (this.index >= this.buffer.length) {
            if (this.mark == 0) {
                byte[] newBuff = new byte[this.buffer.length + this.initialBufferSize];
                System.arraycopy(this.buffer, 0, newBuff, 0, this.buffer.length);
                this.buffer = newBuff;
            } else {
                int length = this.index - this.mark;
                System.arraycopy(this.buffer, this.mark, this.buffer, 0, length);
                this.index = length;
                this.mark = 0;
            }
        }
        try {
            int bytesRead;
            while ((bytesRead = this.is.read(this.buffer, this.index, this.buffer.length - this.index)) == 0) {
            }
            this.bufferLength = bytesRead != -1 ? this.index + bytesRead : -1;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed while reading InputStream", e);
        }
    }

    public static class OffsetInfo {
        private final long startOffset;
        private final long length;
        private final int crlfLength;
        private boolean startsWithMatch = true;

        OffsetInfo(long startOffset, long length, int crlfLength) {
            this.startOffset = startOffset;
            this.length = length;
            this.crlfLength = crlfLength;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public long getLength() {
            return this.length;
        }

        public int getCrlfLength() {
            return this.crlfLength;
        }

        public boolean isStartsWithMatch() {
            return this.startsWithMatch;
        }

        void setStartsWithMatch(int startsWithMatch) {
            this.startsWithMatch = startsWithMatch == 1;
        }
    }
}

