/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.file.monitor;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.nifi.util.file.monitor.UpdateMonitor;

public class MD5SumMonitor
implements UpdateMonitor {
    @Override
    public Object getCurrentState(Path path) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
        try (FileInputStream fis = new FileInputStream(path.toFile());){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = fis.read(buffer)) > -1) {
                if (len <= 0) continue;
                digest.update(buffer, 0, len);
            }
        }
        return ByteBuffer.wrap(digest.digest());
    }
}

