/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.anonymous;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.admin.service.UserService;
import org.apache.nifi.user.NiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.user.NiFiUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

public class NiFiAnonymousUserFilter
extends AnonymousAuthenticationFilter {
    private static final Logger anonymousUserFilterLogger = LoggerFactory.getLogger(NiFiAnonymousUserFilter.class);
    private static final String ANONYMOUS_KEY = "anonymousNifiKey";
    private NiFiProperties properties;
    private UserService userService;

    public NiFiAnonymousUserFilter() {
        super(ANONYMOUS_KEY);
    }

    protected Authentication createAuthentication(HttpServletRequest request) {
        Authentication authentication;
        try {
            NiFiUser user = this.userService.getUserByDn("anonymous");
            NiFiUserDetails userDetails = new NiFiUserDetails(user);
            ArrayList<? extends GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(userDetails.getAuthorities());
            authentication = new AnonymousAuthenticationToken(ANONYMOUS_KEY, (Object)userDetails, authorities);
        }
        catch (AdministrationException ase) {
            anonymousUserFilterLogger.warn("Unable to load anonymous user from accounts database: " + ase.getMessage());
            if (anonymousUserFilterLogger.isDebugEnabled()) {
                anonymousUserFilterLogger.warn("", (Throwable)ase);
            }
            authentication = super.createAuthentication(request);
        }
        return authentication;
    }

    protected boolean applyAnonymousForThisRequest(HttpServletRequest request) {
        if ("http".equalsIgnoreCase(request.getScheme())) {
            return true;
        }
        return !this.properties.getNeedClientAuth();
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

