/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.authentication;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class NiFiAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(NiFiAuthenticationEntryPoint.class);

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException ae) throws IOException, ServletException {
        Object authenticationException = request.getSession().getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (authenticationException instanceof AuthenticationException) {
            ae = (AuthenticationException)authenticationException;
            logger.info(String.format("Rejecting access to web api: %s", ae.getMessage()));
        }
        response.setStatus(403);
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        out.println("Access is denied.");
    }
}

