/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.authorization;

import java.util.Deque;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.service.AccountDisabledException;
import org.apache.nifi.admin.service.AccountNotFoundException;
import org.apache.nifi.admin.service.AccountPendingException;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.admin.service.UserService;
import org.apache.nifi.authorization.Authority;
import org.apache.nifi.user.NiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.DnUtils;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.apache.nifi.web.security.user.NiFiUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class NiFiAuthorizationService
implements UserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(NiFiAuthorizationService.class);
    private UserService userService;
    private NiFiProperties properties;

    public synchronized UserDetails loadUserByUsername(String rawProxyChain) throws UsernameNotFoundException, DataAccessException {
        NiFiUserDetails userDetails = null;
        Deque<String> dnList = DnUtils.tokenizeProxyChain(rawProxyChain);
        if (dnList.size() == 0) {
            logger.warn("Malformed proxy chain: " + rawProxyChain);
            throw new UntrustedProxyException("Malformed proxy chain.");
        }
        NiFiUser proxy = null;
        Iterator<String> dnIter = dnList.iterator();
        while (dnIter.hasNext()) {
            String dn = dnIter.next();
            if (dnIter.hasNext()) {
                try {
                    NiFiUserDetails proxyDetails = this.getNiFiUserDetails(dn);
                    NiFiUser user = proxyDetails.getNiFiUser();
                    if (!user.getAuthorities().contains(Authority.ROLE_PROXY)) {
                        logger.warn(String.format("Proxy '%s' must have '%s' authority. Current authorities: %s", dn, Authority.ROLE_PROXY.toString(), StringUtils.join((Iterable)user.getAuthorities(), (String)", ")));
                        throw new UntrustedProxyException(String.format("Untrusted proxy '%s' must be authorized with '%s'.", dn, Authority.ROLE_PROXY.toString()));
                    }
                    if (proxy != null) {
                        user.setChain(proxy);
                    }
                    proxy = user;
                    continue;
                }
                catch (UsernameNotFoundException unfe) {
                    if (this.properties.getSupportNewAccountRequests()) {
                        try {
                            logger.warn(String.format("Automatic account request generated for unknown proxy: %s", dn));
                            this.userService.createPendingUserAccount(dn, "Automatic account request generated for unknown proxy.");
                            throw new UsernameNotFoundException(String.format("An account request was generated for the proxy '%s'.", dn));
                        }
                        catch (AdministrationException ae) {
                            throw new AuthenticationServiceException(String.format("Unable to create an account request for '%s': %s", dn, ae.getMessage()), (Throwable)ae);
                        }
                        catch (IllegalArgumentException iae) {
                            String message = String.format("Account request was already submitted for '%s'", dn);
                            logger.warn(message);
                            throw new AccountStatusException(message){};
                        }
                    }
                    logger.warn(String.format("Untrusted proxy '%s' must be authorized with '%s' authority: %s", dn, Authority.ROLE_PROXY.toString(), unfe.getMessage()));
                    throw new UntrustedProxyException(String.format("Untrusted proxy '%s' must be authorized with '%s'.", dn, Authority.ROLE_PROXY.toString()));
                }
                catch (AuthenticationException ae) {
                    logger.warn(String.format("Untrusted proxy '%s' must be authorized with '%s' authority: %s", dn, Authority.ROLE_PROXY.toString(), ae.getMessage()));
                    throw new UntrustedProxyException(String.format("Untrusted proxy '%s' must be authorized with '%s'.", dn, Authority.ROLE_PROXY.toString()));
                }
            }
            userDetails = this.getNiFiUserDetails(dn);
            if (proxy == null) continue;
            NiFiUser user = userDetails.getNiFiUser();
            user.setChain(proxy);
        }
        return userDetails;
    }

    private NiFiUserDetails getNiFiUserDetails(String dn) {
        try {
            NiFiUser user = this.userService.checkAuthorization(dn);
            return new NiFiUserDetails(user);
        }
        catch (AdministrationException ase) {
            throw new AuthenticationServiceException(String.format("An error occurred while accessing the user credentials for '%s': %s", dn, ase.getMessage()), (Throwable)ase);
        }
        catch (AccountDisabledException | AccountPendingException e) {
            throw new AccountStatusException(e.getMessage(), e){};
        }
        catch (AccountNotFoundException anfe) {
            throw new UsernameNotFoundException(anfe.getMessage());
        }
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

