/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.user;

import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.user.NiFiUser;
import org.apache.nifi.web.security.user.NiFiUserDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public final class NiFiUserUtils {
    public static Set<String> getAuthorities() {
        Authentication authentication;
        HashSet grantedAuthorities = new HashSet();
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (authentication = context.getAuthentication()) != null) {
            grantedAuthorities.addAll(authentication.getAuthorities());
        }
        HashSet<String> authorities = new HashSet<String>(grantedAuthorities.size());
        for (GrantedAuthority grantedAuthority : grantedAuthorities) {
            authorities.add(grantedAuthority.getAuthority());
        }
        return authorities;
    }

    public static NiFiUser getNiFiUser() {
        Object principal;
        NiFiUser user = null;
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (authentication != null && (principal = authentication.getPrincipal()) instanceof NiFiUserDetails) {
            user = ((NiFiUserDetails)principal).getNiFiUser();
        }
        return user;
    }

    public static String getNiFiUserName() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            return "unknown";
        }
        return user.getUserName();
    }
}

