/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.admin.service.UserService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.DnUtils;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.apache.nifi.web.security.x509.SubjectDnX509PrincipalExtractor;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.apache.nifi.web.security.x509.ocsp.OcspCertificateValidator;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

public class X509AuthenticationFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final String PROXY_ENTITIES_CHAIN = "X-ProxiedEntitiesChain";
    public static final String PROXY_ENTITIES_ACCEPTED = "X-ProxiedEntitiesAccepted";
    public static final String PROXY_ENTITIES_DETAILS = "X-ProxiedEntitiesDetails";
    private final X509CertificateExtractor certificateExtractor = new X509CertificateExtractor();
    private final X509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();
    private OcspCertificateValidator certificateValidator;
    private NiFiProperties properties;
    private UserService userService;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.isNewAccountRequest((HttpServletRequest)request)) {
            if (this.properties.getSupportNewAccountRequests()) {
                X509Certificate certificate = this.certificateExtractor.extractClientCertificate((HttpServletRequest)request);
                if (certificate != null) {
                    Object certificatePrincipal = this.principalExtractor.extractPrincipal(certificate);
                    String principal = certificatePrincipal.toString();
                    this.logger.info((Object)("Requesting new user account for " + principal));
                    try {
                        String justification = request.getParameter("justification");
                        if (justification == null) {
                            justification = "";
                        }
                        this.userService.createPendingUserAccount(principal, justification);
                        httpResponse.setStatus(201);
                        httpResponse.setContentType("text/plain");
                        PrintWriter out = response.getWriter();
                        out.println("Not authorized. User account created. Authorization pending.");
                    }
                    catch (IllegalArgumentException iae) {
                        this.handleUserServiceError((HttpServletRequest)request, httpResponse, 400, iae.getMessage());
                    }
                    catch (AdministrationException ae) {
                        this.handleUserServiceError((HttpServletRequest)request, httpResponse, 500, ae.getMessage());
                    }
                } else {
                    this.handleMissingCertificate((HttpServletRequest)request, httpResponse);
                }
            } else {
                this.handleUserServiceError((HttpServletRequest)request, httpResponse, 404, "This NiFi does not support new account requests.");
            }
        } else {
            try {
                super.doFilter(request, response, chain);
            }
            catch (AuthenticationException ae) {
                if (!this.properties.getNeedClientAuth()) {
                    chain.doFilter(request, response);
                }
                this.handleUnsuccessfulAuthentication((HttpServletRequest)request, httpResponse, ae);
            }
        }
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        X509Certificate certificate = this.certificateExtractor.extractClientCertificate(request);
        if (certificate == null) {
            return null;
        }
        Object certificatePrincipal = this.principalExtractor.extractPrincipal(certificate);
        String principal = DnUtils.formatProxyDn(certificatePrincipal.toString());
        try {
            certificate.checkValidity();
        }
        catch (CertificateExpiredException cee) {
            String message = String.format("Client certificate for (%s) is expired.", principal);
            this.logger.info((Object)message, (Throwable)cee);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"", (Throwable)cee);
            }
            return null;
        }
        catch (CertificateNotYetValidException cnyve) {
            String message = String.format("Client certificate for (%s) is not yet valid.", principal);
            this.logger.info((Object)message, (Throwable)cnyve);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"", (Throwable)cnyve);
            }
            return null;
        }
        try {
            this.certificateValidator.validate(request);
        }
        catch (Exception e) {
            this.logger.info((Object)e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"", (Throwable)e);
            }
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            principal = request.getHeader(PROXY_ENTITIES_CHAIN) + principal;
        }
        this.logger.info((Object)String.format("Attempting request for (%s) %s %s (source ip: %s)", principal, request.getMethod(), request.getRequestURL().toString(), request.getRemoteAddr()));
        return principal;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return this.certificateExtractor.extractClientCertificate(request);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            response.setHeader(PROXY_ENTITIES_ACCEPTED, Boolean.TRUE.toString());
        }
        super.successfulAuthentication(request, response, authResult);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            response.setHeader(PROXY_ENTITIES_DETAILS, failed.getMessage());
        }
        super.unsuccessfulAuthentication(request, response, failed);
    }

    private boolean isNewAccountRequest(HttpServletRequest request) {
        String path;
        return "POST".equalsIgnoreCase(request.getMethod()) && StringUtils.isNotBlank((CharSequence)(path = request.getPathInfo())) && "/controller/users".equals(path);
    }

    private void handleUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException ae) throws IOException {
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        if (ae instanceof UsernameNotFoundException) {
            if (this.properties.getSupportNewAccountRequests()) {
                response.setStatus(401);
                out.println("Not authorized.");
            } else {
                response.setStatus(403);
                out.println("Access is denied.");
            }
        } else if (ae instanceof AccountStatusException) {
            response.setStatus(403);
            out.println(ae.getMessage());
        } else if (ae instanceof UntrustedProxyException) {
            response.setStatus(403);
            out.println(ae.getMessage());
        } else if (ae instanceof AuthenticationServiceException) {
            this.logger.error((Object)String.format("Unable to authorize: %s", ae.getMessage()), (Throwable)ae);
            response.setStatus(500);
            out.println(String.format("Unable to authorize: %s", ae.getMessage()));
        } else {
            this.logger.error((Object)String.format("Unable to authorize: %s", ae.getMessage()), (Throwable)ae);
            response.setStatus(403);
            out.println("Access is denied.");
        }
        this.logger.info((Object)String.format("Rejecting access to web api: %s", ae.getMessage()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"", (Throwable)ae);
        }
    }

    private void handleUserServiceError(HttpServletRequest request, HttpServletResponse response, int responseCode, String message) throws IOException {
        response.setContentType("text/plain");
        response.setStatus(responseCode);
        PrintWriter out = response.getWriter();
        out.println(message);
        this.logger.info((Object)String.format("Unable to process request because %s", message));
    }

    private void handleMissingCertificate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        response.setStatus(400);
        PrintWriter out = response.getWriter();
        out.println("Unable to process request because the user certificate was not specified.");
        this.logger.info((Object)"Unable to process request because the user certificate was not specified.");
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setCertificateValidator(OcspCertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
    }
}

