/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import io.jsonwebtoken.JwtException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.jwt.JwtService;
import org.apache.nifi.web.security.token.NewAccountAuthorizationRequestToken;
import org.apache.nifi.web.security.token.NiFiAuthortizationRequestToken;
import org.apache.nifi.web.security.user.NewAccountRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthenticationFilter
extends NiFiAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    public static final String AUTHORIZATION = "Authorization";
    private JwtService jwtService;

    @Override
    public NiFiAuthortizationRequestToken attemptAuthentication(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        String authorization = request.getHeader(AUTHORIZATION);
        if (authorization == null) {
            return null;
        }
        if (this.jwtService == null) {
            throw new InvalidAuthenticationException("NiFi is not configured to support username/password logins.");
        }
        String token = StringUtils.substringAfterLast((String)authorization, (String)" ");
        try {
            String jwtPrincipal = this.jwtService.getAuthenticationFromToken(token);
            if (this.isNewAccountRequest(request)) {
                return new NewAccountAuthorizationRequestToken(new NewAccountRequest(Arrays.asList(jwtPrincipal), this.getJustification(request)));
            }
            return new NiFiAuthortizationRequestToken(Arrays.asList(jwtPrincipal));
        }
        catch (JwtException e) {
            throw new InvalidAuthenticationException(e.getMessage(), e);
        }
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }
}

