/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.apache.nifi.web.security.token.NewAccountAuthorizationRequestToken;
import org.apache.nifi.web.security.token.NiFiAuthortizationRequestToken;
import org.apache.nifi.web.security.user.NewAccountRequest;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.apache.nifi.web.security.x509.X509IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509AuthenticationFilter
extends NiFiAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(X509AuthenticationFilter.class);
    private X509CertificateExtractor certificateExtractor;
    private X509IdentityProvider certificateIdentityProvider;

    @Override
    public NiFiAuthortizationRequestToken attemptAuthentication(HttpServletRequest request) {
        AuthenticationResponse authenticationResponse;
        if (!request.isSecure()) {
            return null;
        }
        X509Certificate[] certificates = this.certificateExtractor.extractClientCertificate(request);
        if (certificates == null) {
            return null;
        }
        try {
            authenticationResponse = this.certificateIdentityProvider.authenticate(certificates);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidAuthenticationException(iae.getMessage(), iae);
        }
        List<String> proxyChain = ProxiedEntitiesUtils.buildProxiedEntitiesChain(request, authenticationResponse.getIdentity());
        if (this.isNewAccountRequest(request)) {
            return new NewAccountAuthorizationRequestToken(new NewAccountRequest(proxyChain, this.getJustification(request)));
        }
        return new NiFiAuthortizationRequestToken(proxyChain);
    }

    public void setCertificateExtractor(X509CertificateExtractor certificateExtractor) {
        this.certificateExtractor = certificateExtractor;
    }

    public void setCertificateIdentityProvider(X509IdentityProvider certificateIdentityProvider) {
        this.certificateIdentityProvider = certificateIdentityProvider;
    }
}

