/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.node;

import java.io.IOException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.user.NiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.token.NiFiAuthorizationToken;
import org.apache.nifi.web.security.user.NiFiUserDetails;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.apache.nifi.web.security.x509.X509IdentityProvider;
import org.apache.nifi.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.GenericFilterBean;

public class NodeAuthorizedUserFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAuthorizedUserFilter.class);
    public static final String PROXY_USER_DETAILS = "X-ProxiedEntityUserDetails";
    private NiFiProperties properties;
    private X509CertificateExtractor certificateExtractor;
    private X509IdentityProvider certificateIdentityProvider;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        WebApplicationContext ctx;
        FlowController flowController;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String hexEncodedUserDetails = httpServletRequest.getHeader(PROXY_USER_DETAILS);
        if (StringUtils.isNotBlank((CharSequence)hexEncodedUserDetails) && this.properties.isNode() && (flowController = (FlowController)(ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext())).getBean("flowController", FlowController.class)).getNodeId() != null) {
            try {
                X509Certificate[] certificate = this.certificateExtractor.extractClientCertificate(httpServletRequest);
                if (certificate != null) {
                    Serializable userDetailsObj;
                    AuthenticationResponse authenticationResponse = this.certificateIdentityProvider.authenticate(certificate);
                    String clusterManagerIdentity = flowController.getClusterManagerDN();
                    if (clusterManagerIdentity != null && clusterManagerIdentity.equals(authenticationResponse.getIdentity()) && (userDetailsObj = WebUtils.deserializeHexToObject((String)hexEncodedUserDetails)) instanceof NiFiUserDetails) {
                        NiFiUserDetails userDetails = (NiFiUserDetails)((Object)userDetailsObj);
                        NiFiUser user = userDetails.getNiFiUser();
                        this.logger.info((Object)String.format("Attempting request for (%s) %s %s (source ip: %s)", user.getIdentity(), httpServletRequest.getMethod(), httpServletRequest.getRequestURL().toString(), request.getRemoteAddr()));
                        NiFiAuthorizationToken token = new NiFiAuthorizationToken(userDetails);
                        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("Classpath issue detected because failed to deserialize authorized user in request header due to: " + cnfe, (Throwable)cnfe);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        chain.doFilter(request, response);
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setCertificateIdentityProvider(X509IdentityProvider certificateIdentityProvider) {
        this.certificateIdentityProvider = certificateIdentityProvider;
    }

    public void setCertificateExtractor(X509CertificateExtractor certificateExtractor) {
        this.certificateExtractor = certificateExtractor;
    }
}

