/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import java.util.Arrays;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.otp.OtpAuthenticationException;
import org.apache.nifi.web.security.otp.OtpService;
import org.apache.nifi.web.security.token.NiFiAuthorizationRequestToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpAuthenticationFilter
extends NiFiAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(OtpAuthenticationFilter.class);
    private static final Pattern PROVENANCE_DOWNLOAD_PATTERN = Pattern.compile("/controller/provenance/events/[0-9]+/content/(?:(?:output)|(?:input))");
    private static final Pattern QUEUE_DOWNLOAD_PATTERN = Pattern.compile("/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/connections/[a-f0-9\\-]{36}/flowfiles/[a-f0-9\\-]{36}/content");
    private static final Pattern TEMPLATE_DOWNLOAD_PATTERN = Pattern.compile("/controller/templates/[a-f0-9\\-]{36}");
    protected static final String ACCESS_TOKEN = "access_token";
    private OtpService otpService;

    @Override
    public NiFiAuthorizationRequestToken attemptAuthentication(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        String accessToken = request.getParameter(ACCESS_TOKEN);
        if (accessToken == null) {
            return null;
        }
        try {
            String identity = null;
            if (request.getContextPath().equals("/nifi-api")) {
                if (this.isDownloadRequest(request.getPathInfo())) {
                    identity = this.otpService.getAuthenticationFromDownloadToken(accessToken);
                }
            } else {
                identity = this.otpService.getAuthenticationFromUiExtensionToken(accessToken);
            }
            if (identity == null) {
                return null;
            }
            return new NiFiAuthorizationRequestToken(Arrays.asList(identity));
        }
        catch (OtpAuthenticationException oae) {
            throw new InvalidAuthenticationException(oae.getMessage(), (Throwable)((Object)oae));
        }
    }

    private boolean isDownloadRequest(String pathInfo) {
        return PROVENANCE_DOWNLOAD_PATTERN.matcher(pathInfo).matches() || QUEUE_DOWNLOAD_PATTERN.matcher(pathInfo).matches() || TEMPLATE_DOWNLOAD_PATTERN.matcher(pathInfo).matches();
    }

    public void setOtpService(OtpService otpService) {
        this.otpService = otpService;
    }
}

