/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.otp.OtpAuthenticationRequestToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class OtpAuthenticationFilter
extends NiFiAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(OtpAuthenticationFilter.class);
    private static final Pattern PROVENANCE_DOWNLOAD_PATTERN = Pattern.compile("/provenance-events/([0-9]+)/content/((?:input)|(?:output))");
    private static final Pattern QUEUE_DOWNLOAD_PATTERN = Pattern.compile("/flowfile-queues/([a-f0-9\\-]{36})/flowfiles/([a-f0-9\\-]{36})/content");
    private static final Pattern TEMPLATE_DOWNLOAD_PATTERN = Pattern.compile("/templates/[a-f0-9\\-]{36}/download");
    protected static final String ACCESS_TOKEN = "access_token";

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        String accessToken = request.getParameter(ACCESS_TOKEN);
        if (accessToken == null) {
            return null;
        }
        if (request.getContextPath().equals("/nifi-api")) {
            if (this.isDownloadRequest(request.getPathInfo())) {
                return new OtpAuthenticationRequestToken(accessToken, true, request.getRemoteAddr());
            }
        } else {
            return new OtpAuthenticationRequestToken(accessToken, false, request.getRemoteAddr());
        }
        return null;
    }

    private boolean isDownloadRequest(String pathInfo) {
        return PROVENANCE_DOWNLOAD_PATTERN.matcher(pathInfo).matches() || QUEUE_DOWNLOAD_PATTERN.matcher(pathInfo).matches() || TEMPLATE_DOWNLOAD_PATTERN.matcher(pathInfo).matches();
    }
}

