/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public abstract class NiFiAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(NiFiAuthenticationFilter.class);
    private AuthenticationManager authenticationManager;
    private NiFiProperties properties;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (log.isDebugEnabled()) {
            log.debug("Checking secure context token: " + authentication);
        }
        if (this.requiresAuthentication((HttpServletRequest)request)) {
            this.authenticate((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean requiresAuthentication(HttpServletRequest request) {
        return NiFiUserUtils.getNiFiUser() == null;
    }

    private void authenticate(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Authentication authenticationRequest = this.attemptAuthentication(request);
            if (authenticationRequest != null) {
                log.info(String.format("Attempting request for (%s) %s %s (source ip: %s)", authenticationRequest.toString(), request.getMethod(), request.getRequestURL().toString(), request.getRemoteAddr()));
                Authentication authenticated = this.authenticationManager.authenticate(authenticationRequest);
                this.successfulAuthentication(request, response, authenticated);
            }
        }
        catch (AuthenticationException ae) {
            this.unsuccessfulAuthentication(request, response, ae);
            return;
        }
        catch (Exception e) {
            log.error(String.format("Unable to authenticate: %s", e.getMessage()), (Throwable)e);
            response.setContentType("text/plain");
            response.setStatus(500);
            PrintWriter out = response.getWriter();
            out.println(String.format("Failed to authenticate request. Please contact the system administrator.", new Object[0]));
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public abstract Authentication attemptAuthentication(HttpServletRequest var1);

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        log.info("Authentication success for " + authResult);
        SecurityContextHolder.getContext().setAuthentication(authResult);
        ProxiedEntitiesUtils.successfulAuthentication(request, response);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException ae) throws IOException {
        ProxiedEntitiesUtils.unsuccessfulAuthentication(request, response, ae);
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        if (ae instanceof InvalidAuthenticationException) {
            response.setStatus(401);
            out.println(ae.getMessage());
        } else if (ae instanceof UntrustedProxyException) {
            response.setStatus(403);
            out.println(ae.getMessage());
        } else if (ae instanceof AuthenticationServiceException) {
            log.error(String.format("Unable to authenticate: %s", ae.getMessage()), (Throwable)ae);
            response.setStatus(500);
            out.println(String.format("Unable to authenticate: %s", ae.getMessage()));
        } else {
            log.error(String.format("Unable to authenticate: %s", ae.getMessage()), (Throwable)ae);
            response.setStatus(403);
            out.println("Access is denied.");
        }
        log.warn(String.format("Rejecting access to web api: %s", ae.getMessage()));
        if (log.isDebugEnabled()) {
            log.debug("", (Throwable)ae);
        }
    }

    public void destroy() {
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public NiFiProperties getProperties() {
        return this.properties;
    }
}

