/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationProvider;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.apache.nifi.web.security.x509.X509AuthenticationRequestToken;
import org.apache.nifi.web.security.x509.X509IdentityProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class X509AuthenticationProvider
extends NiFiAuthenticationProvider {
    private static final Authorizable PROXY_AUTHORIZABLE = new Authorizable(){

        public Authorizable getParentAuthorizable() {
            return null;
        }

        public Resource getResource() {
            return ResourceFactory.getProxyResource();
        }
    };
    private X509IdentityProvider certificateIdentityProvider;
    private Authorizer authorizer;
    final NiFiProperties properties;

    public X509AuthenticationProvider(X509IdentityProvider certificateIdentityProvider, Authorizer authorizer, NiFiProperties nifiProperties) {
        super(nifiProperties, authorizer);
        this.certificateIdentityProvider = certificateIdentityProvider;
        this.authorizer = authorizer;
        this.properties = nifiProperties;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AuthenticationResponse authenticationResponse;
        X509AuthenticationRequestToken request = (X509AuthenticationRequestToken)authentication;
        try {
            authenticationResponse = this.certificateIdentityProvider.authenticate(request.getCertificates());
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidAuthenticationException(iae.getMessage(), iae);
        }
        if (StringUtils.isBlank((CharSequence)request.getProxiedEntitiesChain())) {
            String mappedIdentity = this.mapIdentity(authenticationResponse.getIdentity());
            return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails((NiFiUser)new StandardNiFiUser.Builder().identity(mappedIdentity).groups(this.getUserGroups(mappedIdentity)).clientAddress(request.getClientAddress()).build()));
        }
        ArrayList<String> proxyChain = new ArrayList<String>(ProxiedEntitiesUtils.tokenizeProxiedEntitiesChain(request.getProxiedEntitiesChain()));
        proxyChain.add(authenticationResponse.getIdentity());
        NiFiUser proxy = null;
        ListIterator chainIter = proxyChain.listIterator(proxyChain.size());
        while (chainIter.hasPrevious()) {
            String identity = (String)chainIter.previous();
            boolean isAnonymous = StringUtils.isBlank((CharSequence)identity);
            if (isAnonymous) {
                if (!this.properties.isAnonymousAuthenticationAllowed().booleanValue()) {
                    throw new InvalidAuthenticationException("Anonymous authentication has not been configured.");
                }
                identity = "anonymous";
            } else {
                identity = this.mapIdentity(identity);
            }
            Set<String> groups = this.getUserGroups(identity);
            String clientAddress = proxy == null ? request.getClientAddress() : null;
            proxy = X509AuthenticationProvider.createUser(identity, groups, proxy, clientAddress, isAnonymous);
            if (!chainIter.hasPrevious()) continue;
            try {
                PROXY_AUTHORIZABLE.authorize(this.authorizer, RequestAction.WRITE, proxy);
            }
            catch (AccessDeniedException e) {
                throw new UntrustedProxyException(String.format("Untrusted proxy %s", identity));
            }
        }
        return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails(proxy));
    }

    protected static NiFiUser createUser(String identity, Set<String> groups, NiFiUser chain, String clientAddress, boolean isAnonymous) {
        if (isAnonymous) {
            return StandardNiFiUser.populateAnonymousUser((NiFiUser)chain, (String)clientAddress);
        }
        return new StandardNiFiUser.Builder().identity(identity).groups(groups).chain(chain).clientAddress(clientAddress).build();
    }

    private Map<String, String> getUserContext(X509AuthenticationRequestToken request) {
        HashMap<String, String> userContext;
        if (!StringUtils.isBlank((CharSequence)request.getClientAddress())) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), request.getClientAddress());
        } else {
            userContext = null;
        }
        return userContext;
    }

    public boolean supports(Class<?> authentication) {
        return X509AuthenticationRequestToken.class.isAssignableFrom(authentication);
    }
}

